/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.api.lootbag;

import com.google.common.collect.Lists;
import java.util.List;
import lhykos.oreshrubs.api.IRegistryName;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LootBagVariant
implements IRegistryName {
    private String registryName;
    private String craftingCoreItemName;
    private ItemStack craftingCoreItemStack = null;
    private List<ResourceLocation> lootTableLocations;
    private boolean hasAdvancedVariant = true;
    private boolean isEnabled = true;
    private int gemColor;
    private int rarity;

    public LootBagVariant(String registryName, int rarity, int gemColor, String craftingCoreItemName, ResourceLocation ... lootTableLocations) {
        this.registryName = registryName;
        this.rarity = rarity;
        this.gemColor = gemColor;
        this.craftingCoreItemName = craftingCoreItemName;
        this.lootTableLocations = Lists.newArrayList((Object[])lootTableLocations);
    }

    public LootBagVariant(String registryName, int rarity, int gemColor, ItemStack craftingCoreItemStack, ResourceLocation ... lootTableLocations) {
        this.registryName = registryName;
        this.rarity = rarity;
        this.gemColor = gemColor;
        this.craftingCoreItemStack = craftingCoreItemStack;
        this.lootTableLocations = Lists.newArrayList((Object[])lootTableLocations);
    }

    public LootBagVariant setCraftingCoreItemStack(ItemStack stack) {
        this.craftingCoreItemStack = stack;
        return this;
    }

    public ItemStack getCraftingCoreItemStack() {
        return this.craftingCoreItemStack;
    }

    public String getCraftingCoreItemName() {
        return this.craftingCoreItemName;
    }

    public String getUppercaseName() {
        String[] split = this.registryName.split("_");
        String s1 = "";
        for (int i = 0; i < split.length; ++i) {
            s1 = s1 + split[i].substring(0, 1).toUpperCase() + split[i].substring(1);
            if (i == split.length - 1) continue;
            s1 = s1 + " ";
        }
        return s1.equals("") ? this.registryName : s1;
    }

    public LootBagVariant disableAdvancedVariant() {
        this.hasAdvancedVariant = false;
        return this;
    }

    @Override
    public String getRegistryName() {
        return this.registryName;
    }

    public int getGemColor() {
        return this.gemColor;
    }

    public int getRarity() {
        return this.rarity;
    }

    public LootBagVariant setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    public boolean hasAdvancedVariant() {
        return this.hasAdvancedVariant;
    }

    public List<ResourceLocation> getLootTableLocations() {
        return this.lootTableLocations;
    }
}

