/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.api.oreshrub;

import lhykos.oreshrubs.api.oreshrub.OreDictPrefix;
import net.minecraft.item.ItemStack;

public class CraftingResult {
    public static final CraftingResult EMPTY = new CraftingResult(null, OreDictPrefix.UNDEFINED, new String[0]);
    private String itemName = "";
    private int itemMeta = 0;
    private int craftingAmount = 1;
    private OreDictPrefix oreDictPrefix = OreDictPrefix.UNDEFINED;
    private String[] customRecipePattern = null;
    private ItemStack resultStack = null;
    private boolean registerOreRecipe = true;

    public CraftingResult(String itemName) {
        this(itemName, 0, 1, OreDictPrefix.UNDEFINED, new String[0]);
    }

    public CraftingResult(String itemName, String ... customRecipePattern) {
        this(itemName, 0, 1, OreDictPrefix.UNDEFINED, customRecipePattern);
    }

    public CraftingResult(ItemStack resultStack, OreDictPrefix oreDictPrefix, String ... customRecipePattern) {
        this.resultStack = resultStack;
        this.oreDictPrefix = oreDictPrefix;
        this.customRecipePattern = customRecipePattern;
    }

    public CraftingResult(String itemName, int itemMeta, int craftingAmount, OreDictPrefix oreDictPrefix, String ... customRecipePattern) {
        this.itemName = itemName;
        this.itemMeta = itemMeta;
        this.oreDictPrefix = oreDictPrefix;
        this.customRecipePattern = customRecipePattern;
        this.craftingAmount = Math.min(craftingAmount, 64);
    }

    public void setResultStack(ItemStack resultStack) {
        this.resultStack = resultStack;
    }

    public void adjustOreDictNameAndRecipe(OreDictPrefix to, String newName) {
        this.itemName = newName;
        this.oreDictPrefix = to;
    }

    public String getItemName() {
        return this.itemName;
    }

    public int getItemMeta() {
        return this.itemMeta;
    }

    public int getCraftingAmount() {
        return this.craftingAmount;
    }

    public ItemStack getResultStack() {
        return this.resultStack;
    }

    public OreDictPrefix getOreDictPrefix() {
        return this.oreDictPrefix;
    }

    public String[] getCustomRecipePattern() {
        return this.customRecipePattern;
    }

    public CraftingResult disableOreRecipe() {
        this.registerOreRecipe = false;
        return this;
    }

    public boolean shouldRegisterOreRecipe() {
        return this.registerOreRecipe;
    }
}

