/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.api.oreshrub;

import javax.annotation.Nullable;
import lhykos.oreshrubs.api.IRegistryName;
import lhykos.oreshrubs.api.damagesource.DamageSourceOreShrubs;
import lhykos.oreshrubs.api.oreshrub.CraftingResult;
import lhykos.oreshrubs.api.oreshrub.GenerationSettings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OreShrubVariant
implements IRegistryName {
    private boolean isEnabled = true;
    private String customDisplayName;
    private String registryName;
    private CraftingResult craftingResult = CraftingResult.EMPTY;
    private GenerationSettings generationSettings = GenerationSettings.EMPTY;
    private IBlockState blockToGrow;
    private int shrubColor;
    private int berryColor;
    private int rarity;
    private int growthChance;
    private int maxHarvestedBerries;
    private int lightLevel;
    private int maxGrowthLight;

    public OreShrubVariant(String registryName, int rarity, int shrubColor, int berryColor) {
        this(registryName, rarity, 15, 4, 0, 10, shrubColor, berryColor);
    }

    public OreShrubVariant(String registryName, int rarity, int growthChance, int maxHarvestedBerries, int lightLevel, int maxGrowthLight, int shrubColor, int berryColor) {
        this.registryName = registryName;
        this.rarity = rarity;
        this.shrubColor = shrubColor;
        this.berryColor = berryColor;
        this.setGrowthChance(growthChance);
        this.setMaxHarvestedBerries(maxHarvestedBerries);
        this.setLightLevel(lightLevel);
        this.setMaxGrowthLight(maxGrowthLight);
    }

    public void onCollide(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            entity.func_70097_a(DamageSourceOreShrubs.ORESHRUB, 1.0f);
        }
    }

    public int onConsumeBerries(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        return 0;
    }

    @Override
    public String getRegistryName() {
        return this.registryName;
    }

    public OreShrubVariant setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    public OreShrubVariant setGrowthChance(int growthChance) {
        this.growthChance = Math.max(growthChance, 1);
        return this;
    }

    public int getGrowthChance() {
        return this.growthChance;
    }

    public OreShrubVariant setMaxHarvestedBerries(int amount) {
        this.maxHarvestedBerries = Math.min(amount, 64);
        return this;
    }

    public int getMaxHarvestedBerries() {
        return this.maxHarvestedBerries;
    }

    public OreShrubVariant setGrowthBlock(IBlockState state) {
        this.blockToGrow = state;
        return this;
    }

    public IBlockState getBlockToGrow() {
        return this.blockToGrow;
    }

    public OreShrubVariant setCraftingResult(CraftingResult craftingResult) {
        this.craftingResult = craftingResult;
        return this;
    }

    public CraftingResult getCraftingResult() {
        return this.craftingResult;
    }

    public int getShrubColor() {
        return this.shrubColor;
    }

    public int getBerryColor() {
        return this.berryColor;
    }

    public int getRipeBerryColor() {
        return this.getBerryColor();
    }

    public OreShrubVariant setGenerationSettings(GenerationSettings generationSettings) {
        this.generationSettings = generationSettings;
        return this;
    }

    public GenerationSettings getGenerationSettings() {
        return this.generationSettings;
    }

    public boolean canGenerateShrubs() {
        return this.generationSettings != null && this.generationSettings != GenerationSettings.EMPTY;
    }

    public OreShrubVariant setCustomDisplayName(String displayName) {
        this.customDisplayName = displayName;
        return this;
    }

    @Nullable
    public String getCustomDisplayName() {
        return this.customDisplayName;
    }

    public OreShrubVariant setLightLevel(int lightLevel) {
        this.lightLevel = Math.min(lightLevel, 15);
        return this;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public OreShrubVariant setMaxGrowthLight(int maxGrowthLight) {
        this.maxGrowthLight = Math.min(maxGrowthLight, 15);
        return this;
    }

    public int getMaxGrowLight() {
        return this.maxGrowthLight;
    }

    public int getRarity() {
        return this.rarity;
    }

    public boolean isConfigurable() {
        return true;
    }
}

