/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.client.model;

import java.util.Random;
import lhykos.oreshrubs.api.LootBagVariants;
import lhykos.oreshrubs.api.lootbag.LootBagVariant;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.common.block.BlockOreShrub;
import lhykos.oreshrubs.common.block.BlockRandomShrub;
import lhykos.oreshrubs.common.helper.LootBagHelper;
import lhykos.oreshrubs.common.helper.OreShrubHelper;
import lhykos.oreshrubs.common.registry.BlockRegistry;
import lhykos.oreshrubs.common.registry.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ColorManager {
    private static final int[] BERRY_COLORS = new int[]{8900394, 3721833, 13289016, 3846605, 4157395, 4182858, 13845311, 181616584, 12014054};
    private static int[] randomShrubBerryColors = new int[20];
    private static final Minecraft mc = Minecraft.func_71410_x();

    public static void registerColorHandler() {
        BlockColors blockColors = mc.func_184125_al();
        ItemColors itemColors = mc.getItemColors();
        ColorManager.registerBlockColorHandlers(blockColors);
        ColorManager.registerItemColorHandlers(blockColors, itemColors);
        for (int i = 0; i < randomShrubBerryColors.length; ++i) {
            ColorManager.randomShrubBerryColors[i] = BERRY_COLORS[new Random().nextInt(BERRY_COLORS.length)];
        }
    }

    private static void registerBlockColorHandlers(BlockColors blockColors) {
        IBlockColor customShrubColor = (state, blockAccess, pos, tintIndex) -> {
            if (state.func_177230_c() instanceof BlockOreShrub) {
                if (((BlockOreShrub)state.func_177230_c()).getOreShrubVariant().getIsEnabled()) {
                    if (tintIndex == 3 || tintIndex == 0) {
                        return ((BlockOreShrub)state.func_177230_c()).getOreShrubVariant().getShrubColor();
                    }
                    if (tintIndex >= 4 && tintIndex <= 23) {
                        return ((BlockOreShrub)state.func_177230_c()).getOreShrubVariant().getRipeBerryColor();
                    }
                } else {
                    return 0x111111;
                }
            }
            return 0xFFFFFF;
        };
        IBlockColor randomShrubBerries = (state, blockAccess, pos, tintIndex) -> {
            if (state.func_177230_c() instanceof BlockRandomShrub && tintIndex >= 4 && tintIndex <= 23) {
                return randomShrubBerryColors[tintIndex - 4];
            }
            return 0xFFFFFF;
        };
        BlockRegistry.allBlocks.stream().filter(block -> block instanceof BlockOreShrub).forEach(block -> blockColors.func_186722_a(customShrubColor, new Block[]{block}));
        blockColors.func_186722_a(randomShrubBerries, new Block[]{BlockRegistry.blockRandomShrub});
    }

    private static void registerItemColorHandlers(BlockColors blockColors, ItemColors itemColors) {
        IItemColor customShrubColorItemBlock = (stack, tintIndex) -> {
            IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return blockColors.func_186724_a(state, null, null, tintIndex);
        };
        IItemColor customBerryColor = (stack, tintIndex) -> {
            OreShrubVariant variant;
            if (tintIndex == 0 && (variant = OreShrubHelper.instance().getVariantFromBerries(stack)).getIsEnabled()) {
                return variant.getBerryColor();
            }
            return 0xFFFFFF;
        };
        IItemColor randomBagGem = (stack, tintIndex) -> {
            LootBagVariant bagType;
            if (tintIndex == 1 && (bagType = LootBagHelper.instance().getVariantFromStack(stack)) != LootBagVariants.EMPTY) {
                return bagType.getGemColor();
            }
            return 0xFFFFFF;
        };
        BlockRegistry.allBlocks.stream().filter(block -> block instanceof BlockOreShrub).forEach(block -> itemColors.func_186731_a(customShrubColorItemBlock, new Block[]{block}));
        itemColors.func_186730_a(customBerryColor, new Item[]{ItemRegistry.itemOreBerries});
        itemColors.func_186730_a(customBerryColor, new Item[]{ItemRegistry.itemCompressedOreBerries});
        itemColors.func_186730_a(randomBagGem, new Item[]{ItemRegistry.itemLootBag});
    }
}

