/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common;

import com.google.common.base.Strings;
import java.io.File;
import lhykos.oreshrubs.OreShrubs;
import lhykos.oreshrubs.api.IOreShrubsPlugin;
import lhykos.oreshrubs.api.OreShrubsPlugin;
import lhykos.oreshrubs.common.config.ConfigHandler;
import lhykos.oreshrubs.common.config.customshrubs.CustomShrubsManager;
import lhykos.oreshrubs.common.entity.villager.CustomVillagers;
import lhykos.oreshrubs.common.helper.OreShrubsHelper;
import lhykos.oreshrubs.common.registry.BlockRegistry;
import lhykos.oreshrubs.common.registry.ItemRegistry;
import lhykos.oreshrubs.common.registry.LootBagRegistry;
import lhykos.oreshrubs.common.registry.OreShrubRegistry;
import lhykos.oreshrubs.common.registry.RecipesRegistry;
import lhykos.oreshrubs.common.tileentity.TileEntityShrubTrap;
import lhykos.oreshrubs.common.util.IProxy;
import lhykos.oreshrubs.common.world.gen.OreShrubsWorldGenerator;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy
implements IProxy {
    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        OreShrubs.plugins = event.getAsmData().getAll(OreShrubsPlugin.class.getCanonicalName());
        this.loadPlugins();
        ConfigHandler.loadConfig(new File(event.getModConfigurationDirectory().getAbsolutePath() + "/oreshrubs/oreshrubs.cfg"));
        CustomShrubsManager customShrubsManager = new CustomShrubsManager(new File(event.getModConfigurationDirectory().getAbsolutePath() + "/" + "oreshrubs" + "/custom-shrubs/"));
        customShrubsManager.readModRegistriesFromFile();
        customShrubsManager.loadCustomOreShrubs();
        BlockRegistry.init();
        ItemRegistry.init();
        this.registerTileEntities();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreShrubsWorldGenerator(), (int)1000);
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        LootBagRegistry.instance().validateVariants();
        OreShrubRegistry.instance().validateVariants();
        RecipesRegistry.registerAllRecipes();
        CustomVillagers.init();
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityShrubTrap.class, (String)"tileEntityShrubTrap");
    }

    private void loadPlugins() {
        OreShrubsHelper helpers = new OreShrubsHelper();
        for (ASMDataTable.ASMData data : OreShrubs.plugins) {
            try {
                String modId = (String)data.getAnnotationInfo().get("value");
                if (Strings.isNullOrEmpty((String)modId)) continue;
                OreShrubs.LOGGER.info("Attempting to load plugin for mod {} from class {}", new Object[]{modId, data.getClassName()});
                if (Loader.isModLoaded((String)modId)) {
                    Class<?> asmClass = Class.forName(data.getClassName());
                    if (IOreShrubsPlugin.class.isAssignableFrom(asmClass)) {
                        IOreShrubsPlugin oreShrubsPlugin = (IOreShrubsPlugin)asmClass.newInstance();
                        oreShrubsPlugin.registerOreShrubs(OreShrubRegistry.instance(), helpers.getShrubHelper());
                        oreShrubsPlugin.registerLootBags(LootBagRegistry.instance(), helpers.getLootBagHelper());
                        OreShrubs.LOGGER.info("Loaded plugin for mod {} from {} successfully.", new Object[]{modId, data.getClassName()});
                        continue;
                    }
                    OreShrubs.LOGGER.error("Mod [}, from {} attempted to register a plugin that did not implement IOreShrubsPlugin", new Object[]{modId, data.getClassName()});
                    continue;
                }
                OreShrubs.LOGGER.warn("Mod {} is not loaded. Skip plugin.", new Object[]{modId});
            }
            catch (Exception e) {
                OreShrubs.LOGGER.error("Error loading plugin for class {}", new Object[]{data.getClassName()});
            }
        }
    }

    @Override
    public IThreadListener getThreadListener(MessageContext ctx) {
        if (ctx.side.isClient()) {
            throw new IProxy.WrongSideException("Tried to get a 'IThreadListener' from client side.");
        }
        return ctx.getServerHandler().field_147369_b.field_71133_b;
    }

    @Override
    public EntityPlayer getPlayer(MessageContext ctx) {
        if (ctx.side.isClient()) {
            return this.getClientPlayer();
        }
        return ctx.getServerHandler().field_147369_b;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        throw new IProxy.WrongSideException("Tried to get a client player from server side.");
    }

    @Override
    public WorldClient getClientWorld() {
        throw new IProxy.WrongSideException("Tried to get a client world from server side.");
    }
}

