/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.block;

import java.util.Random;
import lhykos.oreshrubs.api.oreshrub.IGrowableShrub;
import lhykos.oreshrubs.common.block.BlockBase;
import lhykos.oreshrubs.common.registry.BlockRegistry;
import lhykos.oreshrubs.common.util.ItemStackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockBaseShrub
extends BlockBase {
    protected static final AxisAlignedBB AABB_AGE_0 = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);
    protected static final AxisAlignedBB AABB_AGE_1 = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    protected static final AxisAlignedBB AABB_AGE_2 = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625, 0.8125);
    protected static final AxisAlignedBB AABB_AGE_3 = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)4);
    private boolean fancyShrubLeaves;

    public BlockBaseShrub() {
        super(Material.field_151584_j);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
    }

    public abstract boolean harvestBerries(World var1, BlockPos var2, IBlockState var3, EntityPlayer var4);

    public abstract boolean hasValidPlace(World var1, BlockPos var2, boolean var3);

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && state.func_177230_c() instanceof IGrowableShrub) {
            IGrowableShrub growableShrub = (IGrowableShrub)state.func_177230_c();
            if (growableShrub.canGrow(worldIn, rand, pos, state, false)) {
                growableShrub.grow(worldIn, worldIn.field_73012_v, pos, state);
            }
            if (growableShrub.shouldShrink(worldIn, rand, pos, state)) {
                growableShrub.shrink(worldIn, worldIn.field_73012_v, pos, state);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        Random rand = worldIn.field_73012_v;
        if (heldItem != null && heldItem.func_77973_b() == Items.field_151033_d && (Integer)state.func_177229_b((IProperty)AGE) == 0) {
            worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 0.8f);
            worldIn.func_180501_a(pos, BlockRegistry.blockWitheredOreShrub.func_176223_P(), 2);
            for (int i = 0; i < 10; ++i) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.5, rand.nextGaussian() * 0.05, 0.0, rand.nextGaussian() * 0.05, new int[]{0});
                worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.5, rand.nextGaussian() * 0.05, 0.0, rand.nextGaussian() * 0.05, new int[]{0});
            }
            heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
            return true;
        }
        return this.harvestBerries(worldIn, pos, state, playerIn);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.harvestBerries(worldIn, pos, state, player);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.hasValidPlace(worldIn, pos, false);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.field_72995_K && !this.hasValidPlace(worldIn, pos, true)) {
            ItemStackUtils.spawnItemStackInWorld(worldIn, pos, new ItemStack((Block)this));
            worldIn.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((Integer)state.func_177229_b((IProperty)AGE)) {
            case 0: {
                return AABB_AGE_0;
            }
            case 1: {
                return AABB_AGE_1;
            }
            case 2: {
                return AABB_AGE_2;
            }
            case 3: {
                return AABB_AGE_3;
            }
            case 4: {
                return AABB_AGE_3;
            }
        }
        return field_185505_j;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack stack) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        this.setFancyShrubLeaves(Minecraft.func_71410_x().field_71474_y.field_74347_j);
        return this.fancyShrubLeaves ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public void setFancyShrubLeaves(boolean isFancy) {
        this.fancyShrubLeaves = isFancy;
    }
}

