/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.block;

import java.util.List;
import java.util.Random;
import lhykos.oreshrubs.api.oreshrub.IGrowableShrub;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.client.model.ModelRegistryHelper;
import lhykos.oreshrubs.common.block.BlockBaseShrub;
import lhykos.oreshrubs.common.config.Configs;
import lhykos.oreshrubs.common.helper.OreShrubHelper;
import lhykos.oreshrubs.common.registry.ItemRegistry;
import lhykos.oreshrubs.common.util.ItemStackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class BlockOreShrub
extends BlockBaseShrub
implements IGrowableShrub {
    private OreShrubVariant oreShrubVariant;

    public BlockOreShrub(OreShrubVariant oreShrubVariant) {
        this.oreShrubVariant = oreShrubVariant;
        this.func_149715_a((float)oreShrubVariant.getLightLevel() / 15.0f);
        this.func_149675_a(true);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (Configs.enableNegativeShrubEffects) {
            this.oreShrubVariant.onCollide(worldIn, pos, state, entityIn);
        }
    }

    @Override
    public boolean canGrow(World world, Random random, BlockPos pos, IBlockState state, boolean fromGrowingPowder) {
        return fromGrowingPowder && (Integer)state.func_177229_b((IProperty)AGE) < 3 ? random.nextInt(3) == 0 : world.func_175699_k(pos) <= this.oreShrubVariant.getMaxGrowLight() && random.nextInt(this.oreShrubVariant.getGrowthChance()) == 0;
    }

    @Override
    public void grow(World world, Random random, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age < 4) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 3);
        }
    }

    @Override
    public boolean canUseGrowingPowder(World worldIn, Random random, BlockPos pos, IBlockState state) {
        return worldIn.func_175699_k(pos) <= this.oreShrubVariant.getMaxGrowLight();
    }

    @Override
    public boolean shouldShrink(World world, Random random, BlockPos pos, IBlockState state) {
        return world.func_175699_k(pos) > this.oreShrubVariant.getMaxGrowLight() && random.nextInt(5) == 0;
    }

    @Override
    public void shrink(World world, Random random, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age > 0) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age - 1)), 3);
        }
    }

    @Override
    public boolean harvestBerries(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int age;
        if (!world.field_72995_K && (age = ((Integer)state.func_177229_b((IProperty)AGE)).intValue()) == 4) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age - 1)), 2);
            int maxBerries = this.oreShrubVariant.getMaxHarvestedBerries();
            int size = maxBerries <= 1 ? 1 : (player instanceof FakePlayer ? world.field_73012_v.nextInt(maxBerries - 1) + 1 : world.field_73012_v.nextInt(maxBerries) + 1);
            ItemStack berries = new ItemStack((Item)ItemRegistry.itemOreBerries, size);
            if (berries != null) {
                OreShrubHelper.instance().setVariantToBerries(berries, this.oreShrubVariant);
                ItemStackUtils.spawnItemStackInWorld(world, pos, berries);
                return true;
            }
        }
        return false;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!this.oreShrubVariant.getIsEnabled()) {
            tooltip.add(TextFormatting.DARK_GRAY + "Withered Shrub");
            tooltip.add(TextFormatting.DARK_GRAY + "It seems not to grow here.");
        }
    }

    @Override
    public boolean hasValidPlace(World world, BlockPos pos, boolean ignoreLight) {
        boolean canSurvive = this.canSurviveAt(world, pos, this.oreShrubVariant, true) || this.canSurviveAt(world, pos, this.oreShrubVariant, false);
        boolean light = world.func_175699_k(pos) <= this.oreShrubVariant.getMaxGrowLight();
        return this.oreShrubVariant.getIsEnabled() && canSurvive && (ignoreLight || light);
    }

    public boolean canSurviveAt(World world, BlockPos pos, OreShrubVariant variant, boolean upwards) {
        IBlockState state = world.func_180495_p(upwards ? pos.func_177984_a() : pos.func_177977_b());
        if (state == variant.getBlockToGrow() || variant.getBlockToGrow() == null && state.func_185904_a().func_76220_a() && state.func_185917_h()) {
            return true;
        }
        if (state.func_177230_c() instanceof BlockOreShrub && (Integer)state.func_177229_b((IProperty)AGE) >= 3) {
            return ((BlockOreShrub)state.func_177230_c()).getOreShrubVariant() == variant && this.canSurviveAt(world, upwards ? pos.func_177984_a() : pos.func_177977_b(), variant, upwards);
        }
        return false;
    }

    public String func_149739_a() {
        return "tile.oreshrubs.oreshrub";
    }

    public OreShrubVariant getOreShrubVariant() {
        return this.oreShrubVariant;
    }

    @Override
    public void registerItemModels() {
        ResourceLocation custom = new ResourceLocation("oreshrubs", "oreshrub");
        ModelRegistryHelper.registerCustomStateMapper(this, custom);
        ModelRegistryHelper.registerItemModelForInventory(Item.func_150898_a((Block)this), 0, custom);
    }
}

