/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.block;

import java.util.List;
import java.util.Random;
import lhykos.oreshrubs.api.oreshrub.IGrowableShrub;
import lhykos.oreshrubs.common.block.BlockBaseShrub;
import lhykos.oreshrubs.common.block.BlockOreShrub;
import lhykos.oreshrubs.common.registry.BlockRegistry;
import lhykos.oreshrubs.common.registry.ItemRegistry;
import lhykos.oreshrubs.common.util.ItemStackUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockRandomShrub
extends BlockBaseShrub
implements IGrowableShrub {
    public boolean isTamed = true;

    @Override
    public boolean canUseGrowingPowder(World worldIn, Random random, BlockPos pos, IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 3 && worldIn.func_175699_k(pos) >= 13;
    }

    @Override
    public boolean canGrow(World world, Random random, BlockPos pos, IBlockState state, boolean fromGrowingPowder) {
        return fromGrowingPowder ? random.nextInt(5) == 0 : world.func_175699_k(pos) >= 13 && random.nextInt(40) == 0;
    }

    @Override
    public boolean shouldShrink(World world, Random random, BlockPos pos, IBlockState state) {
        return world.func_175699_k(pos) < 13;
    }

    @Override
    public void grow(World world, Random random, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age < 4) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 3);
        }
    }

    @Override
    public void shrink(World world, Random random, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (world.field_73012_v.nextInt(3) == 0) {
            if (age > 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age - 1)), 3);
            } else if (age == 0) {
                world.func_180501_a(pos, BlockRegistry.blockWitheredOreShrub.func_176223_P(), 3);
            }
        }
    }

    @Override
    public boolean harvestBerries(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int age;
        if (!world.field_72995_K && (age = ((Integer)state.func_177229_b((IProperty)AGE)).intValue()) == 4) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age - 1)), 2);
            ItemStackUtils.spawnItemStackInWorld(world, pos, new ItemStack((Item)ItemRegistry.itemRandomBerries, world.field_73012_v.nextInt(1) + 1));
            return true;
        }
        return false;
    }

    @Override
    public boolean hasValidPlace(World world, BlockPos pos, boolean ignoreLight) {
        boolean light = world.func_175699_k(pos) >= 13;
        boolean ground = this.canSurviveAt(world, pos, false) || this.canSurviveAt(world, pos, true);
        return ground && (light || ignoreLight);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
    }

    public boolean canSurviveAt(World world, BlockPos pos, boolean upwards) {
        IBlockState state = world.func_180495_p(upwards ? pos.func_177984_a() : pos.func_177977_b());
        if (state == Blocks.field_150343_Z.func_176223_P()) {
            return true;
        }
        if (state.func_177230_c() instanceof BlockRandomShrub && (Integer)state.func_177229_b((IProperty)BlockOreShrub.AGE) >= 3) {
            return this.canSurviveAt(world, upwards ? pos.func_177984_a() : pos.func_177977_b(), upwards);
        }
        return false;
    }

    public boolean getIsTamed() {
        return this.isTamed;
    }
}

