/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.block;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import lhykos.oreshrubs.api.damagesource.DamageSourceOreShrubs;
import lhykos.oreshrubs.api.enchanting.IEnchantable;
import lhykos.oreshrubs.client.model.ModelRegistryHelper;
import lhykos.oreshrubs.common.block.BlockBase;
import lhykos.oreshrubs.common.tileentity.TileEntityShrubTrap;
import lhykos.oreshrubs.common.util.ItemStackUtils;
import lhykos.oreshrubs.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BlockShrubTrap
extends BlockBase
implements IEnchantable {
    private static FakePlayer SPIKY_SHRUB;
    private static final AxisAlignedBB AABB;
    private boolean witherProof;

    public BlockShrubTrap(boolean witherProof) {
        super(Material.field_151584_j);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.5f);
        this.func_149752_b(2000.0f);
        this.func_149713_g(1);
        this.witherProof = witherProof;
        if (witherProof) {
            this.func_149675_a(true);
            this.func_149752_b(6000000.0f);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile;
        NBTTagList enchantments = stack.func_77986_q();
        if (enchantments != null && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityShrubTrap) {
            ((TileEntityShrubTrap)tile).setEnchantments(enchantments);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    @Nullable
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        NBTTagList enchantments;
        ItemStack spikeShrub = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(state));
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityShrubTrap && (enchantments = ((TileEntityShrubTrap)tile).getEnchantmentList()) != null) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("ench", (NBTBase)enchantments);
            spikeShrub.func_77982_d(compound);
        }
        return spikeShrub;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!worldIn.field_72995_K && !player.func_184812_l_()) {
            BlockShrubTrap.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.func_185473_a(worldIn, pos, state));
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityShrubTrap();
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.field_72995_K) {
            if (SPIKY_SHRUB == null) {
                SPIKY_SHRUB = new FakePlayer((WorldServer)worldIn, new GameProfile(UUID.randomUUID(), "SpikyShrub"));
            }
            if (entityIn instanceof EntityLivingBase) {
                EntityLivingBase target = (EntityLivingBase)entityIn;
                TileEntity tile = worldIn.func_175625_s(pos);
                if (tile instanceof TileEntityShrubTrap) {
                    ItemStack sword = new ItemStack(Items.field_151041_m);
                    NBTTagList enchantments = ((TileEntityShrubTrap)tile).getEnchantmentList();
                    if (enchantments != null) {
                        NBTTagCompound compound = new NBTTagCompound();
                        compound.func_74782_a("ench", (NBTBase)enchantments);
                        sword.func_77982_d(compound);
                    }
                    float damage = (float)ItemStackUtils.getAttackDamage(sword, EntityEquipmentSlot.MAINHAND) + EnchantmentHelper.func_152377_a((ItemStack)sword, (EnumCreatureAttribute)target.func_70668_bt());
                    if (target.func_110143_aJ() <= damage) {
                        ReflectionHelper.setPrivateValue(EntityLivingBase.class, (Object)((EntityLivingBase)entityIn), (Object)100, (String[])new String[]{"recentlyHit", "field_70718_bc", "bc"});
                        SPIKY_SHRUB.func_184611_a(EnumHand.MAIN_HAND, sword);
                        target.func_70097_a(DamageSourceOreShrubs.fromShrubTrap((EntityLivingBase)SPIKY_SHRUB), damage);
                    } else {
                        target.func_70097_a(DamageSourceOreShrubs.ORESHRUB, damage);
                    }
                    float fireDamage = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)sword);
                    if (fireDamage > 0.0f) {
                        target.func_70015_d(5);
                        target.func_70097_a(DamageSource.field_76370_b, fireDamage * 1.5f);
                    }
                }
            }
        }
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.field_72995_K && this.witherProof) {
            for (int i = 0; i < 5; ++i) {
                double x = (double)pos.func_177958_n() + ThreadLocalRandom.current().nextDouble(0.065, 0.935);
                double y = (double)pos.func_177956_o() + ThreadLocalRandom.current().nextDouble(0.0, 0.375);
                double z = (double)pos.func_177952_p() + ThreadLocalRandom.current().nextDouble(0.065, 0.935);
                if (rand.nextInt(3) != 0) continue;
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[]{0});
            }
        }
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (GuiScreen.func_146272_n()) {
            ItemStack sword = new ItemStack(Items.field_151041_m);
            double base = ItemStackUtils.getAttackDamage(sword, EntityEquipmentSlot.MAINHAND);
            tooltip.add(TextFormatting.BLUE + LangUtils.translate("attribute.name.generic.attackDamage"));
            tooltip.add("" + (base + (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEAD)) + TextFormatting.DARK_GRAY + " " + LangUtils.translate("oreshrubs:shrubtrap.dmg.undead"));
            tooltip.add("" + (base + (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.ARTHROPOD)) + TextFormatting.DARK_GRAY + " " + LangUtils.translate("oreshrubs:shrubtrap.dmg.arthropod"));
            tooltip.add("" + (base + (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED)) + TextFormatting.DARK_GRAY + " " + LangUtils.translate("oreshrubs:shrubtrap.dmg.other"));
            tooltip.add("" + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack) * 1.5f + TextFormatting.DARK_GRAY + " " + LangUtils.translate("oreshrubs:shrubtrap.dmg.fire"));
        } else {
            tooltip.add(TextFormatting.DARK_RED + LangUtils.translate("oreshrubs:shrubtrap.info"));
            tooltip.add(TextFormatting.DARK_GRAY + "Press " + TextFormatting.WHITE + "Shift" + TextFormatting.DARK_GRAY + " to show more.");
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.field_72995_K && !this.func_176196_c(worldIn, pos)) {
            ItemStackUtils.spawnItemStackInWorld(worldIn, pos, this.func_185473_a(worldIn, pos, state));
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return this.witherProof ? BlockRenderLayer.SOLID : BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public Map<Enchantment, Integer> getAllowedEnchantments() {
        HashMap<Enchantment, Integer> allowed = new HashMap<Enchantment, Integer>();
        allowed.put(Enchantments.field_185304_p, Enchantments.field_185304_p.func_77325_b());
        allowed.put(Enchantments.field_185302_k, Enchantments.field_185302_k.func_77325_b());
        allowed.put(Enchantments.field_180312_n, Enchantments.field_180312_n.func_77325_b());
        allowed.put(Enchantments.field_185303_l, Enchantments.field_185303_l.func_77325_b());
        allowed.put(Enchantments.field_77334_n, Enchantments.field_77334_n.func_77325_b());
        return allowed;
    }

    @Override
    public int getEnchantability() {
        return 0;
    }

    @Override
    public void registerItemModels() {
        ResourceLocation custom = new ResourceLocation("oreshrubs", "shrubtrap");
        ModelRegistryHelper.registerCustomStateMapper(this, custom);
        ModelRegistryHelper.registerItemModelForInventory(Item.func_150898_a((Block)this), 0, custom);
    }

    static {
        AABB = new AxisAlignedBB(0.065, 0.0, 0.065, 0.935, 0.19, 0.935);
    }
}

