/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.config;

import java.io.File;
import java.util.ArrayList;
import lhykos.oreshrubs.OreShrubs;
import lhykos.oreshrubs.api.lootbag.LootBagVariant;
import lhykos.oreshrubs.api.oreshrub.CraftingResult;
import lhykos.oreshrubs.api.oreshrub.GenerationSettings;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.common.config.Configs;
import lhykos.oreshrubs.common.registry.LootBagRegistry;
import lhykos.oreshrubs.common.registry.OreShrubRegistry;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHandler {
    private static Configuration config;
    private static File configFile;
    private static ConfigCategory general;
    private static ConfigCategory lootBags;
    private static ConfigCategory recipes;
    private static ConfigCategory generation;

    public static void loadConfig(File file) {
        OreShrubs.LOGGER.info("Loading configuration...");
        configFile = file;
        config = new Configuration(file, null, true);
        try {
            config.load();
            ConfigHandler.loadConfigurations();
        }
        catch (Exception e) {
            OreShrubs.LOGGER.error("Configuration couldn't load entirely. Default values will be applied.", (Throwable)e);
        }
        if (config.hasChanged()) {
            config.save();
        }
        OreShrubs.LOGGER.info("Loading configuration successfully.");
    }

    private static void loadConfigurations() {
        String category = "General";
        general = config.getCategory(category);
        config.setCategoryComment(category, "General settings for the mod.");
        Property prop = config.get(category, "enableNegativeShrubEffects", Configs.enableNegativeShrubEffects);
        prop.setComment("If true, shrubs like uranium or lead will give negative effects when collide with them. (Default: true)");
        Configs.enableNegativeShrubEffects = prop.getBoolean();
        prop = config.get(category, "enableOreShrubsRetrogen", Configs.enableOreShrubsRetrogen);
        prop.setComment("If a chunk have not generated ore shrubs, a regeneration will happen in this chunk. Useful, if you add this mod later to the game and want ore shrubs in already discovered chunks. (Default: true)");
        Configs.enableOreShrubsRetrogen = prop.getBoolean();
        category = "LootBags";
        lootBags = config.getCategory(category);
        config.setCategoryComment(category, "Settings for the loot bags.");
        ArrayList<String> lootBagsOrder = new ArrayList<String>();
        prop = config.get(category, "disableAllLootBags", Configs.disableLootBags);
        prop.setComment("If true, all loot bags will be disabled. (Default: false)");
        Configs.disableLootBags = prop.getBoolean();
        lootBagsOrder.add(prop.getName());
        for (LootBagVariant variant : LootBagRegistry.instance().getAll()) {
            prop = config.get(category, "enable" + variant.getUppercaseName().replace(" ", "") + "LootBag", variant.getIsEnabled()).setRequiresMcRestart(true);
            prop.setComment("Settings for the '" + variant.getUppercaseName() + " Loot Bag'. (Defaults are: [" + String.valueOf(variant.getIsEnabled()) + (variant.hasAdvancedVariant() ? "," + String.valueOf(variant.hasAdvancedVariant()) : "") + "])");
            variant.setIsEnabled(prop.getBoolean());
            lootBagsOrder.add(prop.getName());
            if (variant.hasAdvancedVariant() && !(prop = config.get(category, "enableAdvanced" + variant.getUppercaseName().replace(" ", "") + "LootBag", variant.hasAdvancedVariant()).setRequiresMcRestart(true)).getBoolean()) {
                variant.disableAdvancedVariant();
            }
            lootBagsOrder.add(prop.getName());
        }
        lootBags.setPropertyOrder(lootBagsOrder);
        category = "Recipes";
        recipes = config.getCategory(category);
        config.setCategoryComment(category, "If you don't like my recipes!");
        prop = config.get(category, "enableExperienceBottleRecipe", Configs.enableExperienceBottleRecipe).setRequiresMcRestart(true);
        prop.setComment("If the 'Bottle o' Enchanting' is craftable with the experience berries. (Default: true)");
        Configs.enableExperienceBottleRecipe = prop.getBoolean();
        prop = config.get(category, "enableExtraYellorumRecipe", Configs.enableExtraYellorumRecipe).setRequiresMcRestart(true);
        prop.setComment("If true, a separate 'Yellorium Inogt' recipe will be registered. Useful if Yellorium is not registered as Uranium. (Default: false)");
        Configs.enableExtraYellorumRecipe = prop.getBoolean();
        prop = config.get(category, "enableShrubTrapRecipe", Configs.enableShrubTrapRecipe).setRequiresMcRestart(true);
        prop.setComment("If the shrub trap is craftable. (Default: true)");
        Configs.enableShrubTrapRecipe = prop.getBoolean();
        prop = config.get(category, "enableShrubTrapWitherProofRecipe", Configs.enableShrubTrapWitherProofRecipe).setRequiresMcRestart(true);
        prop.setComment("If the wither proofed shrub trap is craftable. (Default: true)");
        Configs.enableShrubTrapWitherProofRecipe = prop.getBoolean();
        prop = config.get(category, "enableGrowingPowder", Configs.enableGrowingPowder).setRequiresMcRestart(true);
        prop.setComment("If the growing powder is craftable. (Default: true)");
        Configs.enableGrowingPowder = prop.getBoolean();
        category = "Generation";
        generation = config.getCategory(category);
        config.setCategoryComment(category, "Handle the generation of ore shrubs and structures.");
        ArrayList<String> generationOrder = new ArrayList<String>();
        prop = config.get(category, "enableForgottenShrineGeneration", Configs.enableForgottenShrineGeneration);
        prop.setComment("If true, forgotten shrines will be generated in the world. (Default: true)");
        Configs.enableForgottenShrineGeneration = prop.getBoolean();
        generationOrder.add(prop.getName());
        prop = config.get(category, "forgottenShrineMinChunkDistance", Configs.forgottenShrineMinChunkDistance);
        prop.setComment("The minimum distance between two forgotten shrines. They should be rare! (Default: 50)");
        Configs.forgottenShrineMinChunkDistance = prop.getInt();
        generationOrder.add(prop.getName());
        prop = config.get(category, "enableOreShrubGeneration", Configs.enableOreShrubGeneration);
        prop.setComment("If this is set to true, OreShrubs will be generated. (Default: true)");
        Configs.enableOreShrubGeneration = prop.getBoolean();
        generationOrder.add(prop.getName());
        for (OreShrubVariant variant : OreShrubRegistry.instance().getAll()) {
            if (!variant.isConfigurable()) continue;
            GenerationSettings settings = variant.getGenerationSettings();
            CraftingResult craftingResult = variant.getCraftingResult();
            String regName = variant.getRegistryName().substring(0, 1).toUpperCase() + variant.getRegistryName().substring(1);
            prop = config.get(category, "enable" + regName + "OreShrub", variant.getIsEnabled()).setRequiresMcRestart(true);
            prop.setComment("Settings for '" + regName + "OreShrub'. (Defaults are: [" + String.valueOf(variant.getIsEnabled()) + (settings == GenerationSettings.EMPTY ? "" : "," + settings.getMinGenHeight() + "," + settings.getMaxGenHeight() + "," + settings.getMaxVeinSize()) + (craftingResult == CraftingResult.EMPTY ? "])" : "," + craftingResult.shouldRegisterOreRecipe() + "])"));
            variant.setIsEnabled(prop.getBoolean());
            generationOrder.add(prop.getName());
            if (settings != GenerationSettings.EMPTY) {
                prop = config.get(category, variant.getRegistryName() + "MinGenHeight", settings.getMinGenHeight()).setRequiresWorldRestart(true);
                int minGenHeight = prop.getInt();
                generationOrder.add(prop.getName());
                prop = config.get(category, variant.getRegistryName() + "MaxGenHeight", settings.getMaxGenHeight()).setRequiresWorldRestart(true);
                int maxGenHeight = prop.getInt();
                generationOrder.add(prop.getName());
                prop = config.get(category, variant.getRegistryName() + "MaxVeinSize", settings.getMaxVeinSize()).setRequiresWorldRestart(true);
                int maxVeinSize = prop.getInt();
                generationOrder.add(prop.getName());
                variant.setGenerationSettings(new GenerationSettings(settings.getDimension(), settings.getDensity(), minGenHeight, maxGenHeight, maxVeinSize, settings.getVeinShape(), settings.getSpawnBiomes()));
            }
            if (craftingResult == CraftingResult.EMPTY) continue;
            prop = config.get(category, "register" + regName + "OreRecipe", craftingResult.shouldRegisterOreRecipe()).setRequiresMcRestart(true);
            if (!prop.getBoolean()) {
                craftingResult.disableOreRecipe();
            }
            generationOrder.add(prop.getName());
        }
        generation.setPropertyOrder(generationOrder);
    }
}

