/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.config.customshrubs;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import lhykos.oreshrubs.OreShrubs;
import lhykos.oreshrubs.api.oreshrub.CraftingResult;
import lhykos.oreshrubs.api.oreshrub.GenerationSettings;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.common.config.customshrubs.CustomShrubs;
import lhykos.oreshrubs.common.serializer.SerializerCraftingResult;
import lhykos.oreshrubs.common.serializer.SerializerCustomShrubs;
import lhykos.oreshrubs.common.serializer.SerializerGenerationSettings;
import lhykos.oreshrubs.common.serializer.SerializerOreShrubVariant;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.IOUtils;

public class CustomShrubsManager {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CustomShrubs.class, (Object)new SerializerCustomShrubs()).registerTypeAdapter(OreShrubVariant.class, (Object)new SerializerOreShrubVariant()).registerTypeAdapter(GenerationSettings.class, (Object)new SerializerGenerationSettings()).registerTypeAdapter(CraftingResult.class, (Object)new SerializerCraftingResult()).create();
    private final File baseFolder;
    private List<String> modIds;

    public CustomShrubsManager(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readModRegistriesFromFile() {
        block20: {
            OreShrubs.LOGGER.info("Loading custom shrubs...");
            File file = new File(this.baseFolder, "ModRegister.cfg");
            boolean writeDefault = false;
            BufferedReader buffer = null;
            Configuration.UnicodeInputStreamReader input = null;
            this.modIds = new ArrayList<String>();
            try {
                String line;
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists()) {
                    if (file.createNewFile()) {
                        writeDefault = true;
                    } else {
                        OreShrubs.LOGGER.error("Couldn't create custom shrubs registry file. Aborting...");
                        return;
                    }
                }
                if (file.canWrite() && writeDefault) {
                    BufferedWriter bufferedWriter = null;
                    try {
                        bufferedWriter = new BufferedWriter(new FileWriter(file));
                        bufferedWriter.write("# Register here the mods that add custom ore shrubs. #\n");
                        bufferedWriter.write("# STEP 1: Write the modId of the mod you want to add below the comment section without a '#'. #\n");
                        bufferedWriter.write("# STEP 2: Create a json file and name it exactly like the modId you registered here. #\n");
                        bufferedWriter.write("# STEP 3: Fill the json file with the custom shrubs you want to add. For more, visit the Minecraft Forum Thread! #");
                    }
                    catch (IOException ioException) {
                        try {
                            OreShrubs.LOGGER.warn("Unable to write default lines to mod registry file {}", new Object[]{file});
                            ioException.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(bufferedWriter);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Writer)bufferedWriter);
                    }
                    IOUtils.closeQuietly((Writer)bufferedWriter);
                }
                if (!file.canRead()) break block20;
                input = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                buffer = new BufferedReader((Reader)input);
                block10: while ((line = buffer.readLine()) != null) {
                    int i = 0;
                    while (true) {
                        if (i >= line.length()) continue block10;
                        if (!Character.isWhitespace(line.charAt(i))) {
                            if (line.charAt(i) == '#') continue block10;
                            this.modIds.add(line.substring(i));
                            continue block10;
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (IOException ioException) {
                OreShrubs.LOGGER.error("Unable to read the mod registry file for custom shrubs: {}", new Object[]{file});
                ioException.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(buffer);
                IOUtils.closeQuietly(input);
            }
        }
    }

    public void loadCustomOreShrubs() {
        for (String modId : this.modIds) {
            File file = new File(this.baseFolder, modId + ".json");
            if (file.exists()) {
                if (file.isFile()) {
                    String s = null;
                    CustomShrubs customShrubs = null;
                    try {
                        s = Files.toString((File)file, (Charset)Charsets.UTF_8);
                    }
                    catch (IOException ioException) {
                        OreShrubs.LOGGER.error("Couldn't load custom ore shrubs file for mod {}", new Object[]{modId});
                        ioException.printStackTrace();
                    }
                    try {
                        customShrubs = (CustomShrubs)GSON.fromJson(s, CustomShrubs.class);
                    }
                    catch (JsonParseException jsonParseException) {
                        OreShrubs.LOGGER.error("Couldn't load custom ore shrubs file for mod {}", new Object[]{modId});
                        jsonParseException.printStackTrace();
                    }
                    if (customShrubs == null) continue;
                    customShrubs.writeCustomShrubsToRegistry(modId);
                    continue;
                }
                OreShrubs.LOGGER.error("Expected to find custom ore shrubs file for mod {} but it was a folder.", new Object[]{modId});
                continue;
            }
            OreShrubs.LOGGER.warn("No custom shrub file found for modId {}. Make sure you name them right!", new Object[]{modId});
        }
        OreShrubs.LOGGER.info("Loading custom shrubs successfully.");
    }
}

