/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.crafting;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import lhykos.oreshrubs.common.crafting.INBTComparable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedNBTRecipe
extends ShapedOreRecipe {
    public ShapedNBTRecipe(Block result, Object ... recipe) {
        super(result, recipe);
    }

    public ShapedNBTRecipe(Item result, Object ... recipe) {
        super(result, recipe);
    }

    public ShapedNBTRecipe(@Nonnull ItemStack result, Object ... recipe) {
        super(result, recipe);
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    ItemStack stack = (ItemStack)target;
                    if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)slot, (boolean)false)) {
                        return false;
                    }
                    if (this.hasSameNBT(stack, slot)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        ItemStack stack = (ItemStack)itr.next();
                        matched = OreDictionary.itemMatches((ItemStack)stack, (ItemStack)slot, (boolean)false) && this.hasSameNBT(stack, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasSameNBT(ItemStack stack, ItemStack slot) {
        if (stack.func_77973_b() instanceof INBTComparable) {
            if (!((INBTComparable)stack.func_77973_b()).canUsedForCrafting(stack)) {
                return false;
            }
            if (!((INBTComparable)stack.func_77973_b()).areItemStackTagsEqual(stack, slot)) {
                return false;
            }
        } else if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slot)) {
            return false;
        }
        return true;
    }
}

