/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.crafting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import lhykos.oreshrubs.common.crafting.INBTComparable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessNBTRecipe
extends ShapelessOreRecipe {
    public ShapelessNBTRecipe(Block result, Object ... recipe) {
        super(result, recipe);
    }

    public ShapelessNBTRecipe(Item result, Object ... recipe) {
        super(result, recipe);
    }

    public ShapelessNBTRecipe(@Nonnull ItemStack result, Object ... recipe) {
        super(result, recipe);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        ArrayList required = new ArrayList(this.input);
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack slot = inv.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    ItemStack stack = (ItemStack)next;
                    match = OreDictionary.itemMatches((ItemStack)stack, (ItemStack)slot, (boolean)false) && this.hasSameNBT(stack, slot);
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !match) {
                        ItemStack stack = (ItemStack)itr.next();
                        match = OreDictionary.itemMatches((ItemStack)stack, (ItemStack)slot, (boolean)false) && this.hasSameNBT(stack, slot);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    private boolean hasSameNBT(ItemStack stack, ItemStack slot) {
        if (stack.func_77973_b() instanceof INBTComparable) {
            if (!((INBTComparable)stack.func_77973_b()).canUsedForCrafting(stack)) {
                return false;
            }
            if (!((INBTComparable)stack.func_77973_b()).areItemStackTagsEqual(stack, slot)) {
                return false;
            }
        } else if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slot)) {
            return false;
        }
        return true;
    }
}

