/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.handler;

import java.util.List;
import java.util.stream.Collectors;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.common.registry.ItemRegistry;
import lhykos.oreshrubs.common.registry.LootBagRegistry;
import lhykos.oreshrubs.common.registry.OreShrubRegistry;
import lhykos.oreshrubs.common.world.storage.loot.functions.LootFunctionRandomLootBag;
import lhykos.oreshrubs.common.world.storage.loot.functions.LootFunctionRandomOreShrub;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class DungeonLootHandler {
    private static final LootCondition[] NO_CONDITION = new LootCondition[0];
    public static final ResourceLocation FORGOTTEN_SHRINE = new ResourceLocation("oreshrubs", "forgotten_shrine");
    public static final ResourceLocation SHRUB_HOUSE = new ResourceLocation("oreshrubs", "shrub_house");

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool = event.getTable().getPool("main");
        if (pool == null) {
            pool = new LootPool(new LootEntry[0], NO_CONDITION, new RandomValueRange(2.0f, 3.0f), new RandomValueRange(0.0f), "main");
            event.getTable().addPool(pool);
        }
        if (FORGOTTEN_SHRINE.equals((Object)event.getName())) {
            SetCount randomBerriesAmount = new SetCount(NO_CONDITION, new RandomValueRange(2.0f, 4.0f));
            LootEntryItem randomBerriesEntry = new LootEntryItem((Item)ItemRegistry.itemRandomBerries, 15, 0, new LootFunction[]{randomBerriesAmount}, NO_CONDITION, "randomBerries");
            pool.addEntry((LootEntry)randomBerriesEntry);
            SetCount lootBagAmount = new SetCount(NO_CONDITION, new RandomValueRange(1.0f));
            LootFunctionRandomLootBag lootBagNBT = new LootFunctionRandomLootBag(NO_CONDITION, LootBagRegistry.instance().getAll());
            RandomChance randomChance = new RandomChance(0.5f);
            LootEntryItem lootBagEntry = new LootEntryItem((Item)ItemRegistry.itemLootBag, 10, 0, new LootFunction[]{lootBagAmount, lootBagNBT}, new LootCondition[]{randomChance}, "randomLootBag");
            pool.addEntry((LootEntry)lootBagEntry);
        } else if (SHRUB_HOUSE.equals((Object)event.getName())) {
            DungeonLootHandler.addShrubsLoot(pool, OreShrubRegistry.instance().getAll().stream().filter(OreShrubVariant::getIsEnabled).collect(Collectors.toList()));
            SetCount randomBerriesAmount = new SetCount(NO_CONDITION, new RandomValueRange(1.0f, 3.0f));
            LootEntryItem randomBerriesEntry = new LootEntryItem((Item)ItemRegistry.itemRandomBerries, 5, 0, new LootFunction[]{randomBerriesAmount}, NO_CONDITION, "randomBerries");
            pool.addEntry((LootEntry)randomBerriesEntry);
        } else if (LootTableList.field_186425_g.equals((Object)event.getName())) {
            List<OreShrubVariant> netherOreShrubVariants = OreShrubRegistry.instance().getAll().stream().filter(shrubType -> shrubType.getIsEnabled() && shrubType.canGenerateShrubs() && shrubType.getGenerationSettings().getDimension() == -1).collect(Collectors.toList());
            DungeonLootHandler.addShrubsLoot(pool, netherOreShrubVariants);
        } else if (LootTableList.field_186421_c.equals((Object)event.getName())) {
            List<OreShrubVariant> endOreShrubVariants = OreShrubRegistry.instance().getAll().stream().filter(shrubType -> shrubType.getIsEnabled() && shrubType.canGenerateShrubs() && shrubType.getGenerationSettings().getDimension() == 1).collect(Collectors.toList());
            DungeonLootHandler.addShrubsLoot(pool, endOreShrubVariants);
        } else if (LootTableList.field_186424_f.equals((Object)event.getName()) || LootTableList.field_186422_d.equals((Object)event.getName()) || LootTableList.field_186423_e.equals((Object)event.getName())) {
            List<OreShrubVariant> overworldOreShrubVariants = OreShrubRegistry.instance().getAll().stream().filter(shrubType -> shrubType.getIsEnabled() && shrubType.canGenerateShrubs() && shrubType.getGenerationSettings().getDimension() == 0).collect(Collectors.toList());
            DungeonLootHandler.addShrubsLoot(pool, overworldOreShrubVariants);
        }
    }

    private static void addShrubsLoot(LootPool pool, List<OreShrubVariant> shrubs) {
        if (shrubs != null && shrubs.size() > 0) {
            SetCount oreBerryAmount = new SetCount(NO_CONDITION, new RandomValueRange(4.0f, 8.0f));
            LootFunctionRandomOreShrub oreBerryNBT = new LootFunctionRandomOreShrub(NO_CONDITION, shrubs, true);
            RandomChance oreBerryChance = new RandomChance(0.7f);
            pool.addEntry((LootEntry)new LootEntryItem((Item)ItemRegistry.itemOreBerries, 15, 0, new LootFunction[]{oreBerryAmount, oreBerryNBT}, new LootCondition[]{oreBerryChance}, "randomOreBerries"));
            SetCount oreShrubAmount = new SetCount(NO_CONDITION, new RandomValueRange(1.0f, 2.0f));
            LootFunctionRandomOreShrub oreShrubNBT = new LootFunctionRandomOreShrub(NO_CONDITION, shrubs, false);
            RandomChance oreShrubChance = new RandomChance(0.4f);
            pool.addEntry((LootEntry)new LootEntryItem(Items.field_151034_e, 10, 0, new LootFunction[]{oreShrubAmount, oreShrubNBT}, new LootCondition[]{oreShrubChance}, "randomOreShrub"));
        }
    }

    static {
        LootTableList.func_186375_a((ResourceLocation)FORGOTTEN_SHRINE);
        LootTableList.func_186375_a((ResourceLocation)SHRUB_HOUSE);
    }
}

