/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.handler;

import java.util.ArrayList;
import java.util.Random;
import lhykos.oreshrubs.api.LootBagVariants;
import lhykos.oreshrubs.common.helper.LootBagHelper;
import lhykos.oreshrubs.common.registry.LootBagRegistry;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.monster.ZombieType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class MobDropHandler {
    @SubscribeEvent
    public static void lootBagDrop(LivingDropsEvent event) {
        if (event.isRecentlyHit()) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            Random random = event.getEntityLiving().func_70681_au();
            EntityLivingBase entity = event.getEntityLiving();
            if (entity instanceof EntityBlaze) {
                if (random.nextInt(20) == 0) {
                    drops.add(LootBagHelper.instance().getStackFromVariant(LootBagVariants.NETHER_BRIDGE, false));
                }
            } else if (entity instanceof EntitySkeleton) {
                if (((EntitySkeleton)entity).func_189771_df() == SkeletonType.STRAY && random.nextInt(20) == 0) {
                    drops.add(LootBagHelper.instance().getStackFromVariant(LootBagVariants.DESERT_PYRAMID, false));
                }
            } else if (entity instanceof EntityZombie) {
                if (((EntityZombie)entity).func_82231_m()) {
                    if (random.nextInt(5) == 0) {
                        drops.add(LootBagHelper.instance().getStackFromVariant(LootBagVariants.MINESHAFT, false));
                    }
                } else if (((EntityZombie)entity).func_189777_di() == ZombieType.HUSK && random.nextInt(20) == 0) {
                    drops.add(LootBagHelper.instance().getStackFromVariant(LootBagVariants.DESERT_PYRAMID, false));
                }
            } else if (entity instanceof EntityCaveSpider) {
                if (random.nextInt(50) == 0) {
                    drops.add(LootBagHelper.instance().getStackFromVariant(LootBagVariants.MINESHAFT, false));
                }
            } else if (entity instanceof EntityDragon) {
                drops.add(LootBagHelper.instance().getStackFromVariant(LootBagVariants.END_CITY, true));
                drops.add(LootBagHelper.instance().getStackFromVariant(LootBagVariants.END_CITY, true));
            } else if (entity instanceof EntityWither) {
                drops.add(LootBagHelper.instance().getStackFromVariant(LootBagRegistry.instance().getRandom(random), true));
            }
            for (ItemStack stack : drops) {
                event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, stack));
            }
        }
    }
}

