/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.handler;

import lhykos.oreshrubs.api.damagesource.DamageSourceOreShrubs;
import lhykos.oreshrubs.common.tileentity.TileEntityShrubTrap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Mod.EventBusSubscriber
public class ShrubTrapHandler {
    @SubscribeEvent
    public static void onLootingLevelEvent(LootingLevelEvent event) {
        TileEntity tile;
        if (event.getDamageSource().field_76373_n.equals(DamageSourceOreShrubs.ORESHRUB.field_76373_n) && (tile = event.getEntity().field_70170_p.func_175625_s(event.getEntity().func_180425_c())) instanceof TileEntityShrubTrap) {
            int lootLevel;
            ItemStack sword = new ItemStack(Items.field_151041_m);
            NBTTagList enchantments = ((TileEntityShrubTrap)tile).getEnchantmentList();
            if (enchantments != null) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74782_a("ench", (NBTBase)enchantments);
                sword.func_77982_d(compound);
            }
            if ((lootLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)sword)) > 0) {
                event.setLootingLevel(lootLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        if (event.getSource().field_76373_n.equals(DamageSourceOreShrubs.ORESHRUB.field_76373_n)) {
            EntityLivingBase entity = event.getEntityLiving();
            int lootingLevel = event.getLootingLevel();
            for (int i = 0; i < lootingLevel; ++i) {
                ItemStack head;
                if (entity.field_70170_p.field_73012_v.nextInt(3) != 0) continue;
                if (entity.field_70170_p.field_73012_v.nextInt(100) == 0 && (head = ShrubTrapHandler.getHeadForMobType(entity)) != null) {
                    event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, head));
                }
                if (!(entity instanceof EntityLiving)) break;
                int xp = 0;
                try {
                    xp = (Integer)ReflectionHelper.getPrivateValue(EntityLiving.class, (Object)((EntityLiving)entity), (String[])new String[]{"experienceValue", "field_70728_aV", "aV"});
                }
                catch (ReflectionHelper.UnableToFindFieldException unableToFindFieldException) {
                    // empty catch block
                }
                if (xp <= 0) break;
                xp = entity.field_70170_p.field_73012_v.nextInt(xp);
                while (xp > 0) {
                    int split = EntityXPOrb.func_70527_a((int)xp);
                    EntityXPOrb extraExp = new EntityXPOrb(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, xp -= split);
                    entity.field_70170_p.func_72838_d((Entity)extraExp);
                }
                break;
            }
        }
    }

    private static ItemStack getHeadForMobType(EntityLivingBase entity) {
        int meta = -1;
        if (entity instanceof EntitySkeleton) {
            meta = ((EntitySkeleton)entity).func_189771_df() == SkeletonType.NORMAL ? 0 : 1;
        } else if (entity instanceof EntityZombie) {
            meta = 2;
        } else if (entity instanceof EntityCreeper) {
            meta = 4;
        } else if (entity instanceof EntityPlayer) {
            ItemStack playerHead = new ItemStack(Items.field_151144_bL, 1, 3);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("SkullOwner", entity.func_70005_c_());
            playerHead.func_77982_d(compound);
            return playerHead;
        }
        if (meta != -1) {
            return new ItemStack(Items.field_151144_bL, 1, meta);
        }
        return null;
    }
}

