/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.helper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class JsonHelper {
    public static String getString(JsonObject jsonObject, String memberName, String fallback) {
        if (jsonObject.has(memberName)) {
            if (jsonObject.get(memberName).isJsonPrimitive()) {
                return jsonObject.get(memberName).getAsString();
            }
            throw new JsonSyntaxException("Expected to find a String for member: " + memberName);
        }
        return fallback;
    }

    public static JsonArray getJsonArray(JsonObject jsonObject, String memberName, JsonArray fallback) {
        if (jsonObject.has(memberName)) {
            if (jsonObject.get(memberName).isJsonArray()) {
                return jsonObject.get(memberName).getAsJsonArray();
            }
            throw new JsonSyntaxException("Expected to find a Array for member: " + memberName);
        }
        return fallback;
    }

    public static Item getItem(JsonObject jsonObject, String memberName, Item fallback) {
        String s = JsonHelper.getString(jsonObject, memberName, null);
        if (s != null) {
            ResourceLocation res = new ResourceLocation(s);
            if (ForgeRegistries.ITEMS.containsKey(res)) {
                return (Item)ForgeRegistries.ITEMS.getValue(res);
            }
            throw new JsonSyntaxException("Expected to find a Item for member: " + memberName);
        }
        return fallback;
    }

    public static Block getBlock(JsonObject jsonObject, String memberName, Block fallback) {
        String s = JsonHelper.getString(jsonObject, memberName, null);
        if (s != null) {
            ResourceLocation res = new ResourceLocation(s);
            if (ForgeRegistries.BLOCKS.containsKey(res)) {
                return (Block)ForgeRegistries.BLOCKS.getValue(res);
            }
            throw new JsonSyntaxException("Expected to find a Block for member: " + memberName);
        }
        return fallback;
    }

    public static Biome getBiome(JsonElement jsonElement, String memberName, Biome fallback) {
        String s = null;
        try {
            s = JsonUtils.func_151206_a((JsonElement)jsonElement, (String)memberName);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (s != null) {
            ResourceLocation res = new ResourceLocation(s);
            if (ForgeRegistries.BIOMES.containsKey(res)) {
                return (Biome)ForgeRegistries.BIOMES.getValue(res);
            }
            throw new JsonSyntaxException("Expected to find a Biome for member: " + memberName);
        }
        return fallback;
    }
}

