/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.helper;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import lhykos.oreshrubs.api.ILootBagHelper;
import lhykos.oreshrubs.api.LootBagVariants;
import lhykos.oreshrubs.api.lootbag.LootBagVariant;
import lhykos.oreshrubs.common.registry.ItemRegistry;
import lhykos.oreshrubs.common.registry.LootBagRegistry;
import lhykos.oreshrubs.common.util.LangUtils;
import lhykos.oreshrubs.common.util.nbt.NBTItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.items.ItemStackHandler;

public class LootBagHelper
implements ILootBagHelper {
    private static LootBagHelper INSTANCE;
    public static final int MAX_ITEMS = 3;
    public static final String TAG_LOOT_BAG = "LootBag";
    public static final String TAG_BAG_NAME = "Name";
    public static final String TAG_TAKEN_ITEMS = "TakenItems";
    public static final String TAG_ADVANCED = "Advanced";
    public static final String TAG_LOOT_GENERATED = "IsLootGenerated";
    public static final String TAG_INVENTORY = "Inventory";

    public LootBagHelper() {
        INSTANCE = this;
    }

    @Override
    public void initializeLootBag(ItemStack lootBag, LootBagVariant variant) {
        NBTTagCompound bagNBT = new NBTTagCompound();
        bagNBT.func_74778_a(TAG_BAG_NAME, variant.getRegistryName());
        bagNBT.func_74768_a(TAG_TAKEN_ITEMS, 0);
        NBTItemUtils.getStackNBT(lootBag).func_74782_a(TAG_LOOT_BAG, (NBTBase)bagNBT);
    }

    @Override
    public boolean hasLootBagTag(ItemStack lootBag) {
        return NBTItemUtils.hasTag(lootBag, TAG_LOOT_BAG);
    }

    public NBTTagCompound getLootBagTag(ItemStack stack) {
        if (NBTItemUtils.hasTag(stack, TAG_LOOT_BAG)) {
            return NBTItemUtils.getStackNBT(stack).func_74775_l(TAG_LOOT_BAG);
        }
        return new NBTTagCompound();
    }

    @Override
    public boolean isAdvanced(ItemStack lootBag) {
        return this.hasLootBagTag(lootBag) && this.getLootBagTag(lootBag).func_74764_b(TAG_ADVANCED);
    }

    @Override
    public void makeAdvanced(ItemStack lootBag) {
        if (this.hasLootBagTag(lootBag)) {
            NBTTagCompound advancedTag = new NBTTagCompound();
            advancedTag.func_74757_a(TAG_LOOT_GENERATED, false);
            advancedTag.func_74782_a(TAG_INVENTORY, (NBTBase)new ItemStackHandler(27).serializeNBT());
            this.getLootBagTag(lootBag).func_74782_a(TAG_ADVANCED, (NBTBase)advancedTag);
        }
    }

    @Override
    public String getLootBagDisplayName(ItemStack lootBag) {
        String name = LangUtils.translate(lootBag.func_77977_a() + ".name");
        LootBagVariant variant = this.getVariantFromStack(lootBag);
        return variant.getUppercaseName() + " " + name;
    }

    @Override
    public ItemStack getStackFromVariant(LootBagVariant lootBagVariant, boolean advanced) {
        ItemStack bag = new ItemStack((Item)ItemRegistry.itemLootBag);
        this.initializeLootBag(bag, lootBagVariant);
        if (advanced && lootBagVariant.hasAdvancedVariant()) {
            this.makeAdvanced(bag);
        }
        return bag;
    }

    @Override
    public LootBagVariant getVariantFromStack(ItemStack lootBag) {
        if (this.hasLootBagTag(lootBag)) {
            return LootBagRegistry.instance().getFromRegistryName(this.getLootBagTag(lootBag).func_74779_i(TAG_BAG_NAME));
        }
        return LootBagVariants.EMPTY;
    }

    public boolean hasLootGenerated(ItemStack lootBag) {
        return this.isAdvanced(lootBag) && this.getLootBagTag(lootBag).func_74775_l(TAG_ADVANCED).func_74767_n(TAG_LOOT_GENERATED);
    }

    public void setLootGenerated(ItemStack lootBag) {
        if (this.isAdvanced(lootBag)) {
            this.getLootBagTag(lootBag).func_74775_l(TAG_ADVANCED).func_74757_a(TAG_LOOT_GENERATED, true);
        }
    }

    public void writeInventoryToBag(ItemStack lootBag, ItemStackHandler inventory) {
        if (this.isAdvanced(lootBag)) {
            this.getLootBagTag(lootBag).func_74775_l(TAG_ADVANCED).func_74782_a(TAG_INVENTORY, (NBTBase)inventory.serializeNBT());
        }
    }

    public ItemStackHandler getInventoryFromBag(ItemStack lootBag) {
        if (this.isAdvanced(lootBag)) {
            ItemStackHandler inventory = new ItemStackHandler(27);
            inventory.deserializeNBT(this.getLootBagTag(lootBag).func_74775_l(TAG_ADVANCED).func_74775_l(TAG_INVENTORY));
            return inventory;
        }
        return null;
    }

    public boolean hasEmptyInventory(ItemStack lootBag) {
        ItemStackHandler inventory = this.getInventoryFromBag(lootBag);
        if (inventory != null) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i) == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTakenItems(ItemStack lootBag) {
        if (this.hasLootBagTag(lootBag)) {
            return this.getLootBagTag(lootBag).func_74762_e(TAG_TAKEN_ITEMS);
        }
        return -1;
    }

    @Override
    public void incrementTakenItems(ItemStack lootBag, int amount) {
        if (this.hasLootBagTag(lootBag)) {
            this.getLootBagTag(lootBag).func_74768_a(TAG_TAKEN_ITEMS, this.getLootBagTag(lootBag).func_74762_e(TAG_TAKEN_ITEMS) + amount);
        }
    }

    public boolean canTakeMoreLoot(ItemStack lootBag) {
        return !this.hasEmptyInventory(lootBag) && (this.isAdvanced(lootBag) || this.getTakenItems(lootBag) < 3);
    }

    public ItemStack getRandomSingleLootItem(ItemStack lootBag, WorldServer world, @Nullable Random random, @Nullable EntityPlayer player) {
        List<ResourceLocation> lootTables;
        if (this.hasLootBagTag(lootBag) && !(lootTables = this.getVariantFromStack(lootBag).getLootTableLocations()).isEmpty()) {
            List loot;
            random = random == null ? world.field_73012_v : random;
            LootTable lootTable = world.func_184146_ak().func_186521_a(lootTables.get(random.nextInt(lootTables.size())));
            LootContext.Builder builder = new LootContext.Builder(world);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da());
            }
            if (!(loot = lootTable.func_186462_a(random, builder.func_186471_a())).isEmpty()) {
                return (ItemStack)loot.get(random.nextInt(loot.size()));
            }
        }
        return null;
    }

    public void fillLootBagInventory(ItemStack lootBag, WorldServer world, @Nullable Random random, @Nullable EntityPlayer player) {
        List<ResourceLocation> lootTables;
        if (!this.hasLootGenerated(lootBag) && !(lootTables = this.getVariantFromStack(lootBag).getLootTableLocations()).isEmpty()) {
            random = random == null ? world.field_73012_v : random;
            LootTable lootTable = world.func_184146_ak().func_186521_a(lootTables.get(random.nextInt(lootTables.size())));
            LootContext.Builder builder = new LootContext.Builder(world);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da());
            }
            InventoryBasic basicInv = new InventoryBasic("", false, 27);
            lootTable.func_186460_a((IInventory)basicInv, random, builder.func_186471_a());
            ItemStack[] loot = new ItemStack[basicInv.func_70302_i_()];
            for (int i = 0; i < basicInv.func_70302_i_(); ++i) {
                loot[i] = basicInv.func_70301_a(i);
            }
            this.writeInventoryToBag(lootBag, new ItemStackHandler(loot));
            this.setLootGenerated(lootBag);
        }
    }

    public static LootBagHelper instance() {
        if (INSTANCE == null) {
            INSTANCE = new LootBagHelper();
        }
        return INSTANCE;
    }
}

