/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.helper;

import java.util.stream.Collectors;
import lhykos.oreshrubs.api.IShrubHelper;
import lhykos.oreshrubs.api.OreShrubVariants;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.common.block.BlockOreShrub;
import lhykos.oreshrubs.common.registry.BlockRegistry;
import lhykos.oreshrubs.common.registry.ItemRegistry;
import lhykos.oreshrubs.common.registry.OreShrubRegistry;
import lhykos.oreshrubs.common.util.LangUtils;
import lhykos.oreshrubs.common.util.nbt.NBTItemUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class OreShrubHelper
implements IShrubHelper {
    public static final String TAG_SHRUB_VARIANT = "OreShrubVariant";
    public static final String TAG_SUB_VARIANT_NAME = "Name";
    private static OreShrubHelper INSTANCE;

    public OreShrubHelper() {
        INSTANCE = this;
    }

    @Override
    public ItemStack getShrub(OreShrubVariant variant) {
        return this.getShrub(variant, 1);
    }

    @Override
    public ItemStack getShrub(OreShrubVariant variant, int size) {
        ItemStack shrub = null;
        BlockOreShrub oreShrub = this.getBlockFromVariant(variant);
        if (oreShrub != null) {
            shrub = new ItemStack((Block)oreShrub, size);
        }
        return shrub;
    }

    @Override
    public ItemStack getBerries(OreShrubVariant variant) {
        return this.getBerries(variant, 1);
    }

    @Override
    public ItemStack getCompressedBerries(OreShrubVariant variant) {
        return this.getCompressedBerries(variant, 1);
    }

    @Override
    public ItemStack getBerries(OreShrubVariant variant, int size) {
        ItemStack berries = new ItemStack((Item)ItemRegistry.itemOreBerries, size);
        this.setVariantToBerries(berries, variant);
        return berries;
    }

    @Override
    public ItemStack getCompressedBerries(OreShrubVariant variant, int size) {
        ItemStack cBerries = new ItemStack((Item)ItemRegistry.itemCompressedOreBerries, size);
        this.setVariantToBerries(cBerries, variant);
        return cBerries;
    }

    private BlockOreShrub getBlockFromVariant(OreShrubVariant variant) {
        return (BlockOreShrub)BlockRegistry.allOreShrubs.stream().filter(blockOreShrub -> blockOreShrub.getOreShrubVariant() == variant).collect(Collectors.toList()).get(0);
    }

    @Override
    public OreShrubVariant getVariantFromBerries(ItemStack stack) {
        NBTTagCompound nbtVariant;
        if (NBTItemUtils.hasTag(stack, TAG_SHRUB_VARIANT) && (nbtVariant = NBTItemUtils.getStackNBT(stack).func_74775_l(TAG_SHRUB_VARIANT)).func_74764_b(TAG_SUB_VARIANT_NAME)) {
            return OreShrubRegistry.instance().getFromRegistryName(nbtVariant.func_74779_i(TAG_SUB_VARIANT_NAME));
        }
        return OreShrubVariants.EMPTY;
    }

    @Override
    public void setVariantToBerries(ItemStack stack, OreShrubVariant type) {
        NBTTagCompound nbtVariant = new NBTTagCompound();
        nbtVariant.func_74778_a(TAG_SUB_VARIANT_NAME, type.getRegistryName());
        NBTItemUtils.getStackNBT(stack).func_74782_a(TAG_SHRUB_VARIANT, (NBTBase)nbtVariant);
    }

    @Override
    public String getDisplayName(OreShrubVariant variant, boolean forBlock) {
        String name = TextFormatting.RESET + (forBlock ? LangUtils.translate("tile.oreshrubs:oreshrub.name") : LangUtils.translate("item.oreshrubs:oreberries.name"));
        if (variant != OreShrubVariants.EMPTY) {
            if (variant.getCustomDisplayName() != null) {
                return LangUtils.translate(variant.getCustomDisplayName()) + " " + name;
            }
            ItemStack output = variant.getCraftingResult().getResultStack();
            if (output != null) {
                return output.func_77953_t().field_77937_e + output.func_82833_r() + " " + name;
            }
        }
        return name;
    }

    public static OreShrubHelper instance() {
        if (INSTANCE == null) {
            INSTANCE = new OreShrubHelper();
        }
        return INSTANCE;
    }
}

