/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.item;

import java.util.List;
import lhykos.oreshrubs.api.lootbag.LootBagVariant;
import lhykos.oreshrubs.common.crafting.INBTComparable;
import lhykos.oreshrubs.common.helper.LootBagHelper;
import lhykos.oreshrubs.common.item.ItemBase;
import lhykos.oreshrubs.common.registry.ItemRegistry;
import lhykos.oreshrubs.common.registry.LootBagRegistry;
import lhykos.oreshrubs.common.util.LangUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemLootBag
extends ItemBase
implements INBTComparable {
    public ItemLootBag() {
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            boolean isAdvanced = LootBagHelper.instance().isAdvanced(stack);
            if (isAdvanced) {
                ItemStackHandler inventory = LootBagHelper.instance().getInventoryFromBag(stack);
                if (inventory == null) {
                    return new ActionResult(EnumActionResult.PASS, (Object)stack);
                }
                LootBagHelper.instance().fillLootBagInventory(stack, (WorldServer)worldIn, worldIn.field_73012_v, playerIn);
                playerIn.openGui((Object)"oreshrubs", 0, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
            } else {
                ItemStack loot = LootBagHelper.instance().getRandomSingleLootItem(stack, (WorldServer)worldIn, worldIn.field_73012_v, playerIn);
                if (loot != null) {
                    LootBagHelper.instance().incrementTakenItems(stack, 1);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)loot);
                    if (ItemLootBag.hasNoUsesLeft(stack)) {
                        stack = new ItemStack((Item)ItemRegistry.itemEmptyBag);
                    }
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public static boolean hasNoUsesLeft(ItemStack stack) {
        return LootBagHelper.instance().hasLootGenerated(stack) && LootBagHelper.instance().hasEmptyInventory(stack) || !LootBagHelper.instance().isAdvanced(stack) && LootBagHelper.instance().getTakenItems(stack) >= 3;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayer && stack.func_77973_b() == ItemRegistry.itemLootBag && ItemLootBag.hasNoUsesLeft(stack)) {
            --stack.field_77994_a;
            ((EntityPlayer)entityIn).field_71071_by.func_70299_a(itemSlot, new ItemStack((Item)ItemRegistry.itemEmptyBag));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return LootBagHelper.instance().getLootBagDisplayName(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        LootBagVariant bagType = LootBagHelper.instance().getVariantFromStack(stack);
        if (bagType.getIsEnabled()) {
            if (LootBagHelper.instance().isAdvanced(stack)) {
                tooltip.add(TextFormatting.GOLD + LangUtils.translate("oreshrubs:lootbag.info.advanced"));
                tooltip.add(TextFormatting.GREEN + LangUtils.translate("oreshrubs:lootbag.info.choose_advanced"));
            } else {
                tooltip.add(TextFormatting.GREEN + LangUtils.translate("oreshrubs:lootbag.info.choose_normal"));
            }
            tooltip.add(TextFormatting.DARK_GRAY + LangUtils.translate("oreshrubs:lootbag.info.contains") + " " + bagType.getUppercaseName() + " " + LangUtils.translate("oreshrubs:lootbag.info.loot"));
        }
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        LootBagRegistry.instance().getAll().stream().filter(LootBagVariant::getIsEnabled).forEach(bagType -> {
            ItemStack bag = LootBagHelper.instance().getStackFromVariant((LootBagVariant)bagType, false);
            subItems.add(bag.func_77946_l());
            if (bagType.hasAdvancedVariant()) {
                LootBagHelper.instance().makeAdvanced(bag);
                subItems.add(bag);
            }
        });
    }

    @Override
    public boolean canUsedForCrafting(ItemStack stack) {
        return stack != null && LootBagHelper.instance().isAdvanced(stack) ? !LootBagHelper.instance().hasLootGenerated(stack) : LootBagHelper.instance().getTakenItems(stack) == 0;
    }

    @Override
    public boolean areItemStackTagsEqual(ItemStack stack, ItemStack stack2) {
        if (stack != null && stack2 != null) {
            if (stack.func_77973_b() != stack2.func_77973_b()) {
                return false;
            }
            if (LootBagHelper.instance().hasLootBagTag(stack) && LootBagHelper.instance().hasLootBagTag(stack2)) {
                if (LootBagHelper.instance().getVariantFromStack(stack) != LootBagHelper.instance().getVariantFromStack(stack2)) {
                    return false;
                }
                if (LootBagHelper.instance().getTakenItems(stack) != LootBagHelper.instance().getTakenItems(stack2)) {
                    return false;
                }
                boolean adv1 = LootBagHelper.instance().isAdvanced(stack);
                boolean adv2 = LootBagHelper.instance().isAdvanced(stack2);
                if (adv1 && adv2 ? LootBagHelper.instance().hasLootGenerated(stack) && LootBagHelper.instance().hasLootGenerated(stack2) : !adv1 && !adv2) {
                    return true;
                }
            }
        }
        return false;
    }
}

