/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.network;

import lhykos.oreshrubs.OreShrubs;
import lhykos.oreshrubs.common.network.packets.PacketBase;
import lhykos.oreshrubs.common.util.MinecraftUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    private static SimpleNetworkWrapper networkWrapper;
    private static byte messageID;
    private ClientHandler clientHandler;
    private ServerHandler serverHandler;

    public void init() {
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("oreshrubs");
        if (MinecraftUtils.isClient()) {
            this.clientHandler = new ClientHandler();
        }
        this.serverHandler = new ServerHandler();
    }

    public void registerMessage(Class<? extends PacketBase> messageClass) {
        if (MinecraftUtils.isClient()) {
            byte by = messageID;
            messageID = (byte)(by + 1);
            networkWrapper.registerMessage((IMessageHandler)this.clientHandler, messageClass, (int)by, Side.CLIENT);
        }
        byte by = messageID;
        messageID = (byte)(by + 1);
        networkWrapper.registerMessage((IMessageHandler)this.serverHandler, messageClass, (int)by, Side.SERVER);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        networkWrapper.sendTo(message, player);
    }

    public void sendToServer(IMessage message) {
        networkWrapper.sendToServer(message);
    }

    public void sendToDiemension(IMessage message, int dimensionId) {
        networkWrapper.sendToDimension(message, dimensionId);
    }

    public void sendToAll(IMessage message) {
        networkWrapper.sendToAll(message);
    }

    public void sendAllAround(IMessage message, NetworkRegistry.TargetPoint targetPoint) {
        networkWrapper.sendToAllAround(message, targetPoint);
    }

    static {
        messageID = 0;
    }

    private static class ServerHandler
    implements IMessageHandler<PacketBase, IMessage> {
        private ServerHandler() {
        }

        public IMessage onMessage(PacketBase message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                OreShrubs.proxy.getThreadListener(ctx).func_152344_a(() -> message.handleServerMessage(OreShrubs.proxy.getPlayer((MessageContext)ctx).field_70170_p, OreShrubs.proxy.getPlayer(ctx)));
            }
            return null;
        }
    }

    private static class ClientHandler
    implements IMessageHandler<PacketBase, IMessage> {
        private ClientHandler() {
        }

        public IMessage onMessage(PacketBase message, MessageContext ctx) {
            OreShrubs.proxy.getThreadListener(ctx).func_152344_a(() -> message.handleClientMessage((World)OreShrubs.proxy.getClientWorld(), OreShrubs.proxy.getClientPlayer()));
            return null;
        }
    }
}

