/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.network.packets;

import io.netty.buffer.ByteBuf;
import lhykos.oreshrubs.common.network.packets.PacketBase;
import lhykos.oreshrubs.common.tileentity.ITileEntitySync;
import lhykos.oreshrubs.common.util.NetworkUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketSyncTileEntity
implements PacketBase {
    private BlockPos pos;
    private NBTTagCompound compound;

    public PacketSyncTileEntity() {
    }

    public PacketSyncTileEntity(BlockPos pos, NBTTagCompound tagCompound) {
        this.pos = pos;
        this.compound = tagCompound;
    }

    public void toBytes(ByteBuf buf) {
        NetworkUtils.writeBlockPosToBuf(buf, this.pos);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkUtils.readBlockPosFromBuf(buf);
        this.compound = ByteBufUtils.readTag((ByteBuf)buf);
    }

    @Override
    public void handleClientMessage(World world, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(this.pos);
        if (tileEntity instanceof ITileEntitySync) {
            ((ITileEntitySync)tileEntity).handleServerPacket(this.compound);
        }
    }

    @Override
    public void handleServerMessage(World world, EntityPlayer pLayer) {
    }
}

