/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.registry;

import java.util.ArrayList;
import java.util.List;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.common.block.BlockBase;
import lhykos.oreshrubs.common.block.BlockOreShrub;
import lhykos.oreshrubs.common.block.BlockRandomShrub;
import lhykos.oreshrubs.common.block.BlockShrubTrap;
import lhykos.oreshrubs.common.block.BlockWitheredOreShrub;
import lhykos.oreshrubs.common.item.ItemBlockMod;
import lhykos.oreshrubs.common.item.ItemBlockOreShrub;
import lhykos.oreshrubs.common.registry.ItemRegistry;
import lhykos.oreshrubs.common.registry.OreShrubRegistry;
import lhykos.oreshrubs.common.util.CreativeTab;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockRegistry {
    public static List<BlockBase> allBlocks = new ArrayList<BlockBase>();
    public static List<BlockOreShrub> allOreShrubs = new ArrayList<BlockOreShrub>();
    public static BlockWitheredOreShrub blockWitheredOreShrub;
    public static BlockShrubTrap blockShrubTrap;
    public static BlockShrubTrap blockShrubTrapWitherProof;
    public static BlockRandomShrub blockRandomShrub;

    public static void init() {
        BlockRegistry.initOreShrubVariants();
        blockWitheredOreShrub = BlockRegistry.register(new BlockWitheredOreShrub(), "oreshrub_withered");
        blockShrubTrap = BlockRegistry.register(new BlockShrubTrap(false), "shrubtrap");
        blockShrubTrapWitherProof = BlockRegistry.register(new BlockShrubTrap(true), "shrubtrap_witherproof");
        blockRandomShrub = BlockRegistry.register(new BlockRandomShrub(), "oreshrub_random");
    }

    private static void initOreShrubVariants() {
        OreShrubRegistry.instance().getAll().forEach(variant -> {
            BlockOreShrub shrubBlock = new BlockOreShrub((OreShrubVariant)variant);
            allOreShrubs.add(BlockRegistry.register(shrubBlock, new ItemBlockOreShrub(shrubBlock), "oreshrub_" + variant.getRegistryName()));
        });
    }

    private static <T extends BlockBase> T register(T block, String regName) {
        block.setRegistryName(regName);
        block.func_149663_c("oreshrubs:" + regName.toLowerCase());
        block.func_149647_a(CreativeTab.ORESHRUBS);
        ItemBlockMod itemBlock = (ItemBlockMod)new ItemBlockMod(block).setRegistryName(regName);
        GameRegistry.register(block);
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
        allBlocks.add(block);
        ItemRegistry.allItemBlocks.add(itemBlock);
        return block;
    }

    private static <T extends BlockBase, E extends ItemBlockMod> T register(T block, E itemBlock, String name) {
        block.setRegistryName(name);
        block.func_149663_c("oreshrubs:" + name.toLowerCase());
        block.func_149647_a(CreativeTab.ORESHRUBS);
        ItemBlockMod itemBlockMod = (ItemBlockMod)itemBlock.setRegistryName(name);
        GameRegistry.register(block);
        GameRegistry.register(itemBlock);
        allBlocks.add(block);
        ItemRegistry.allItemBlocks.add(itemBlockMod);
        return block;
    }
}

