/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import lhykos.oreshrubs.OreShrubs;
import lhykos.oreshrubs.api.IRegistryName;
import lhykos.oreshrubs.api.IVariantRegistry;
import lhykos.oreshrubs.api.LootBagVariants;
import lhykos.oreshrubs.api.lootbag.LootBagVariant;
import lhykos.oreshrubs.common.config.Configs;
import lhykos.oreshrubs.common.util.ItemStackUtils;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.Loader;

public class LootBagRegistry
implements IVariantRegistry<LootBagVariant> {
    private static LootBagRegistry INSTANCE;
    private List<LootBagVariant> lootBagVariants = new ArrayList<LootBagVariant>();

    public LootBagRegistry() {
        INSTANCE = this;
        this.init();
    }

    @Override
    public void register(LootBagVariant variant) {
        for (LootBagVariant lootBagVariant : this.lootBagVariants) {
            if (!variant.getRegistryName().equals(lootBagVariant.getRegistryName())) continue;
            OreShrubs.LOGGER.warn("LootBagVariant with name " + variant.getRegistryName() + "is always registered.");
        }
        this.lootBagVariants.add(variant);
    }

    @Override
    public void remove(LootBagVariant variant) {
        this.lootBagVariants.remove(variant);
    }

    @Override
    public void replace(LootBagVariant replacementVariant) {
        this.remove(replacementVariant);
        this.lootBagVariants.add(replacementVariant);
    }

    @Override
    public LootBagVariant getFromRegistryName(String registryName) {
        for (LootBagVariant variant : this.lootBagVariants) {
            if (!(variant instanceof IRegistryName) || !variant.getRegistryName().equals(registryName)) continue;
            return variant;
        }
        return LootBagVariants.EMPTY;
    }

    @Override
    public LootBagVariant getRandom(Random random) {
        List variants = this.getAll().stream().filter(LootBagVariant::getIsEnabled).collect(Collectors.toList());
        if (!variants.isEmpty()) {
            return (LootBagVariant)variants.get(random.nextInt(variants.size()));
        }
        return LootBagVariants.EMPTY;
    }

    @Override
    public List<LootBagVariant> getAll() {
        return this.lootBagVariants;
    }

    public void validateVariants() {
        for (LootBagVariant variant : this.lootBagVariants) {
            if (variant == LootBagVariants.EMPTY || Configs.disableLootBags) {
                variant.setIsEnabled(false);
                continue;
            }
            for (ResourceLocation resourceLocation : variant.getLootTableLocations()) {
                if (resourceLocation.func_110624_b().equals("minecraft") || Loader.isModLoaded((String)resourceLocation.func_110624_b())) continue;
                variant.setIsEnabled(false);
                break;
            }
            if (!variant.getIsEnabled()) continue;
            ItemStack stack = variant.getCraftingCoreItemStack();
            if (stack == null) {
                stack = ItemStackUtils.getFromItemName(variant.getCraftingCoreItemName(), 1, 0);
                if (stack == null) {
                    stack = ItemStackUtils.getFromOreDictName(variant.getCraftingCoreItemName());
                }
                variant.setCraftingCoreItemStack(stack);
            }
            if (stack != null) continue;
            variant.setIsEnabled(false);
        }
    }

    public void init() {
        LootBagVariants.EMPTY = new LootBagVariant("empty", -1, 0, "", LootTableList.field_186419_a).disableAdvancedVariant().setIsEnabled(false);
        LootBagVariants.BONUS_CHEST = new LootBagVariant("bonus_chest", 1, 9323788, "logWood", LootTableList.field_186420_b);
        this.register(LootBagVariants.BONUS_CHEST);
        LootBagVariants.END_CITY = new LootBagVariant("end_city", 10, 12016106, new ItemStack(Items.field_185157_bK), LootTableList.field_186421_c);
        this.register(LootBagVariants.END_CITY);
        LootBagVariants.SIMPLE_DUNGEON = new LootBagVariant("simple_dungeon", 6, 10667092, new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE), LootTableList.field_186422_d);
        this.register(LootBagVariants.SIMPLE_DUNGEON);
        LootBagVariants.BLACKSMITH = new LootBagVariant("blacksmith", 5, 0x333333, new ItemStack(Items.field_151040_l), LootTableList.field_186423_e);
        this.register(LootBagVariants.BLACKSMITH);
        LootBagVariants.STRONGHOLD = new LootBagVariant("stronghold", 4, 15701537, new ItemStack(Items.field_151061_bv), LootTableList.field_186428_j, LootTableList.field_186426_h, LootTableList.field_186427_i);
        this.register(LootBagVariants.STRONGHOLD);
        LootBagVariants.NETHER_BRIDGE = new LootBagVariant("nether_bridge", 4, 10500409, new ItemStack(Items.field_151072_bj), LootTableList.field_186425_g);
        this.register(LootBagVariants.NETHER_BRIDGE);
        LootBagVariants.MINESHAFT = new LootBagVariant("mineshaft", 3, 0x7A7A7A, new ItemStack(Items.field_151143_au), LootTableList.field_186424_f);
        this.register(LootBagVariants.MINESHAFT);
        LootBagVariants.DESERT_PYRAMID = new LootBagVariant("desert_pyramid", 6, 15913781, "gemEmerald", LootTableList.field_186429_k);
        this.register(LootBagVariants.DESERT_PYRAMID);
        LootBagVariants.JUNGLE_TEMPLE = new LootBagVariant("jungle_temple", 4, 4100935, new ItemStack(Items.field_151100_aR, 1, 3), LootTableList.field_186430_l);
        this.register(LootBagVariants.JUNGLE_TEMPLE);
        LootBagVariants.IGLOO = new LootBagVariant("igloo", 3, 8114904, new ItemStack(Blocks.field_150403_cj), LootTableList.field_186431_m);
        this.register(LootBagVariants.IGLOO);
        LootBagVariants.FISHING = new LootBagVariant("fishing", 2, 0x177DD1, new ItemStack((Item)Items.field_151112_aM), LootTableList.field_186387_al, LootTableList.field_186390_ao, LootTableList.field_186389_an).disableAdvancedVariant();
        this.register(LootBagVariants.FISHING);
    }

    public static LootBagRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new LootBagRegistry();
        }
        return INSTANCE;
    }
}

