/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.registry;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import lhykos.oreshrubs.OreShrubs;
import lhykos.oreshrubs.api.IRegistryName;
import lhykos.oreshrubs.api.IVariantRegistry;
import lhykos.oreshrubs.api.OreShrubVariants;
import lhykos.oreshrubs.api.oreshrub.CraftingResult;
import lhykos.oreshrubs.api.oreshrub.GenerationSettings;
import lhykos.oreshrubs.api.oreshrub.OreDictPrefix;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.api.oreshrub.VeinShape;
import lhykos.oreshrubs.common.block.BlockOreShrub;
import lhykos.oreshrubs.common.util.ItemStackUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class OreShrubRegistry
implements IVariantRegistry<OreShrubVariant> {
    private static OreShrubRegistry INSTANCE;
    private List<OreShrubVariant> oreShrubVariants = new ArrayList<OreShrubVariant>();

    public OreShrubRegistry() {
        INSTANCE = this;
        this.init();
    }

    @Override
    public void register(OreShrubVariant variant) {
        for (OreShrubVariant oreShrubVariant : this.oreShrubVariants) {
            if (!oreShrubVariant.getRegistryName().equals(variant.getRegistryName())) continue;
            OreShrubs.LOGGER.warn("OreShrubVariant with name " + variant.getRegistryName() + " is always registered!");
            return;
        }
        this.oreShrubVariants.add(variant);
    }

    @Override
    public void remove(OreShrubVariant variant) {
        this.oreShrubVariants.remove(variant);
    }

    @Override
    public void replace(OreShrubVariant replacement) {
        this.remove(replacement);
        this.oreShrubVariants.add(replacement);
    }

    @Override
    public OreShrubVariant getFromRegistryName(String registryName) {
        for (OreShrubVariant variant : this.oreShrubVariants) {
            if (!(variant instanceof IRegistryName) || !variant.getRegistryName().equals(registryName)) continue;
            return variant;
        }
        return OreShrubVariants.EMPTY;
    }

    @Override
    public OreShrubVariant getRandom(Random rand) {
        List variants = this.getAll().stream().filter(OreShrubVariant::getIsEnabled).collect(Collectors.toList());
        if (!variants.isEmpty()) {
            return (OreShrubVariant)variants.get(rand.nextInt(variants.size()));
        }
        return OreShrubVariants.EMPTY;
    }

    @Override
    public List<OreShrubVariant> getAll() {
        return this.oreShrubVariants;
    }

    public void validateVariants() {
        this.oreShrubVariants.forEach(variant -> {
            CraftingResult result;
            if (variant.getIsEnabled() && (result = variant.getCraftingResult()) != CraftingResult.EMPTY) {
                this.initCraftingResult(result);
                if (result.getResultStack() == null) {
                    variant.setIsEnabled(false);
                }
            }
        });
    }

    private void initCraftingResult(CraftingResult result) {
        ItemStack resultStack = result.getResultStack();
        String itemName = result.getItemName();
        if (resultStack == null) {
            resultStack = ItemStackUtils.getFromItemName(itemName, 1, result.getItemMeta());
            if (resultStack == null) {
                String newName;
                OreDictPrefix prefix = OreDictPrefix.getFromOreDictName(itemName);
                if (prefix == OreDictPrefix.INGOT && (resultStack = ItemStackUtils.getFromOreDictName(newName = itemName.replaceFirst(prefix.getName(), OreDictPrefix.NUGGET.getName()))) != null) {
                    result.adjustOreDictNameAndRecipe(OreDictPrefix.NUGGET, newName);
                    resultStack.field_77994_a = result.getCraftingAmount();
                    result.setResultStack(resultStack);
                    return;
                }
                resultStack = ItemStackUtils.getFromOreDictName(itemName);
                if (resultStack != null && result.getOreDictPrefix() == OreDictPrefix.UNDEFINED) {
                    result.adjustOreDictNameAndRecipe(OreDictPrefix.getFromOreDictName(itemName), itemName);
                }
            }
            if (resultStack != null) {
                resultStack.field_77994_a = result.getCraftingAmount();
            }
            result.setResultStack(resultStack);
        }
    }

    public static OreShrubRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new OreShrubRegistry();
        }
        return INSTANCE;
    }

    public void init() {
        OreShrubVariants.EMPTY = new OreShrubVariant("empty", 0, 0, 0).setIsEnabled(false);
        OreShrubVariants.IRON = new OreShrubVariant("iron", 6, 0xAAA9A9, 0xAAA9A9).setGenerationSettings(new GenerationSettings(0, 1, 60, 4)).setCraftingResult(new CraftingResult("ingotIron"));
        this.register(OreShrubVariants.IRON);
        OreShrubVariants.GOLD = new OreShrubVariant("gold", 10, 15853079, 15853079).setGenerationSettings(new GenerationSettings(0, 1, 35, 4)).setCraftingResult(new CraftingResult("ingotGold"));
        this.register(OreShrubVariants.GOLD);
        OreShrubVariants.QUARTZ = new OreShrubVariant("quartz", 6, 13879227, 13879227).setGrowthBlock(Blocks.field_150424_aL.func_176223_P()).setGenerationSettings(new GenerationSettings(-1, 1, 1, 128, 4, VeinShape.NORMAL, Lists.newArrayList((Object[])new Biome[]{Biomes.field_76778_j}))).setCraftingResult(new CraftingResult("gemQuartz"));
        this.register(OreShrubVariants.QUARTZ);
        OreShrubVariants.EXPERIENCE = new OreShrubVariant("experience", 10, 6880768, 6880768){

            @Override
            public int onConsumeBerries(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
                if (playerIn.func_70093_af()) {
                    worldIn.func_72838_d((Entity)new EntityXPOrb(worldIn, playerIn.field_70165_t + 0.5, playerIn.field_70163_u + 0.5, playerIn.field_70161_v + 0.5, 8 * itemStackIn.field_77994_a));
                    return itemStackIn.field_77994_a;
                }
                worldIn.func_72838_d((Entity)new EntityXPOrb(worldIn, playerIn.field_70165_t + 0.5, playerIn.field_70163_u + 0.5, playerIn.field_70161_v + 0.5, 8));
                return 1;
            }
        }.setCustomDisplayName("oreshrubs:variant.experience").setGenerationSettings(new GenerationSettings(0, 1, 30, 4)).setLightLevel(3);
        this.register(OreShrubVariants.EXPERIENCE);
        OreShrubVariants.COPPER = new OreShrubVariant("copper", 6, 14120228, 14120228).setGenerationSettings(new GenerationSettings(0, 25, 60, 4)).setCraftingResult(new CraftingResult("ingotCopper"));
        this.register(OreShrubVariants.COPPER);
        OreShrubVariants.TIN = new OreShrubVariant("tin", 5, 11642257, 11642257).setGenerationSettings(new GenerationSettings(0, 15, 40, 4)).setCraftingResult(new CraftingResult("ingotTin"));
        this.register(OreShrubVariants.TIN);
        OreShrubVariants.LEAD = new OreShrubVariant("lead", 8, 0x333550, 0x333550){

            @Override
            public void onCollide(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
                if (!worldIn.field_72995_K && entityIn instanceof EntityLivingBase && state.func_177230_c() instanceof BlockOreShrub && ((BlockOreShrub)state.func_177230_c()).getOreShrubVariant() == this) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60));
                }
            }
        }.setGenerationSettings(new GenerationSettings(0, 1, 30, 4)).setCraftingResult(new CraftingResult("ingotLead"));
        this.register(OreShrubVariants.LEAD);
        OreShrubVariants.ALUMINUM = new OreShrubVariant("aluminum", 8, 13229795, 13229795).setGenerationSettings(new GenerationSettings(0, 25, 60, 4)).setCraftingResult(new CraftingResult("ingotAluminum"));
        this.register(OreShrubVariants.ALUMINUM);
        OreShrubVariants.NICKEL = new OreShrubVariant("nickel", 9, 10197622, 10197622).setGenerationSettings(new GenerationSettings(0, 10, 20, 3)).setCraftingResult(new CraftingResult("ingotNickel"));
        this.register(OreShrubVariants.NICKEL);
        OreShrubVariants.SILVER = new OreShrubVariant("silver", 7, 0xFEFEFE, 0xFEFEFE).setGenerationSettings(new GenerationSettings(0, 15, 40, 3)).setCraftingResult(new CraftingResult("ingotSilver"));
        this.register(OreShrubVariants.SILVER);
        OreShrubVariants.URANIUM = new OreShrubVariant("uranium", 10, 507925, 507925){

            @Override
            public void onCollide(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
                if (!worldIn.field_72995_K && entityIn instanceof EntityLivingBase && state.func_177230_c() instanceof BlockOreShrub && ((BlockOreShrub)state.func_177230_c()).getOreShrubVariant() == this) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 60));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76438_s, 60));
                }
            }
        }.setGenerationSettings(new GenerationSettings(0, 30, 60, 4)).setCraftingResult(new CraftingResult("ingotUranium")).setLightLevel(3);
        this.register(OreShrubVariants.URANIUM);
        OreShrubVariants.DRACONIUM = new OreShrubVariant("draconium", 25, 7026600, 7026600).setGrowthBlock(Blocks.field_150377_bs.func_176223_P()).setGenerationSettings(new GenerationSettings(1, 1, 1, 128, 3, VeinShape.PILLAR_DOWN, Lists.newArrayList((Object[])new Biome[]{Biomes.field_76779_k}))).setCraftingResult(new CraftingResult("ingotDraconium")).setGrowthChance(30);
        this.register(OreShrubVariants.DRACONIUM);
        OreShrubVariants.COBALT = new OreShrubVariant("cobalt", 20, 938421, 938421).setGrowthBlock(Blocks.field_150424_aL.func_176223_P()).setGenerationSettings(new GenerationSettings(-1, 1, 30, 128, 4, VeinShape.NORMAL, Lists.newArrayList((Object[])new Biome[]{Biomes.field_76778_j}))).setCraftingResult(new CraftingResult("ingotCobalt"));
        this.register(OreShrubVariants.COBALT);
        OreShrubVariants.ARDITE = new OreShrubVariant("ardite", 20, 11675671, 11675671).setGrowthBlock(Blocks.field_150424_aL.func_176223_P()).setGenerationSettings(new GenerationSettings(-1, 1, 30, 128, 4, VeinShape.NORMAL, Lists.newArrayList((Object[])new Biome[]{Biomes.field_76778_j}))).setCraftingResult(new CraftingResult("ingotArdite"));
        this.register(OreShrubVariants.ARDITE);
        OreShrubVariants.BLACK_QUARTZ = new OreShrubVariant("quartzBlack", 10, 0x1E1E1E, 0x1E1E1E).setGenerationSettings(new GenerationSettings(0, 1, 60, 4)).setCraftingResult(new CraftingResult("gemQuartzBlack"));
        this.register(OreShrubVariants.BLACK_QUARTZ);
        OreShrubVariants.DARK_GEM = new OreShrubVariant("dark", 7, 0x222222, 0x222222).setGenerationSettings(new GenerationSettings(0, 6, 66, 2, VeinShape.PILLAR_UP)).setCraftingResult(new CraftingResult("gemDark"));
        this.register(OreShrubVariants.DARK_GEM);
        OreShrubVariants.CERTUS_QUARTZ = new OreShrubVariant("certusQuartz", 7, 13822196, 13822196).setGenerationSettings(new GenerationSettings(0, 5, 60, 2, VeinShape.PILLAR_DOWN)).setCraftingResult(new CraftingResult("crystalCertusQuartz", "# #", " # ")).setGrowthChance(25);
        this.register(OreShrubVariants.CERTUS_QUARTZ);
    }
}

