/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.registry;

import java.util.List;
import lhykos.oreshrubs.api.OreShrubVariants;
import lhykos.oreshrubs.api.lootbag.LootBagVariant;
import lhykos.oreshrubs.api.oreshrub.CraftingResult;
import lhykos.oreshrubs.api.oreshrub.OreDictPrefix;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.common.config.Configs;
import lhykos.oreshrubs.common.crafting.ShapedNBTRecipe;
import lhykos.oreshrubs.common.crafting.ShapelessNBTRecipe;
import lhykos.oreshrubs.common.helper.LootBagHelper;
import lhykos.oreshrubs.common.helper.OreShrubHelper;
import lhykos.oreshrubs.common.registry.BlockRegistry;
import lhykos.oreshrubs.common.registry.ItemRegistry;
import lhykos.oreshrubs.common.registry.LootBagRegistry;
import lhykos.oreshrubs.common.registry.OreShrubRegistry;
import lhykos.oreshrubs.common.util.ItemStackUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipesRegistry {
    public static void registerAllRecipes() {
        RecipeSorter.register((String)"shapedNBTRecipe", ShapedNBTRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"shapelessNBTRecipe", ShapelessNBTRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipesRegistry.registerOreBerriesRecipes();
        RecipesRegistry.registerItemRecipes();
        if (!Configs.disableLootBags) {
            RecipesRegistry.registerLootBagRecipes();
        }
    }

    private static void registerLootBagRecipes() {
        for (LootBagVariant variant : LootBagRegistry.instance().getAll()) {
            ItemStack craftingCoreItem;
            if (!variant.getIsEnabled() || (craftingCoreItem = variant.getCraftingCoreItemStack()) == null) continue;
            GameRegistry.addRecipe((IRecipe)new ShapedNBTRecipe(LootBagHelper.instance().getStackFromVariant(variant, false), " C ", "BEB", " B ", Character.valueOf('E'), ItemRegistry.itemEmptyBag, Character.valueOf('B'), ItemRegistry.itemRandomBerries, Character.valueOf('C'), craftingCoreItem));
            if (!variant.hasAdvancedVariant()) continue;
            ItemStack advancedBag = LootBagHelper.instance().getStackFromVariant(variant, true);
            GameRegistry.addRecipe((IRecipe)new ShapedNBTRecipe(advancedBag, " B ", "BPB", " B ", Character.valueOf('P'), Items.field_151122_aG, Character.valueOf('B'), LootBagHelper.instance().getStackFromVariant(variant, false)));
        }
    }

    private static void registerOreBerriesRecipes() {
        for (OreShrubVariant variant : OreShrubRegistry.instance().getAll()) {
            if (!variant.getIsEnabled()) continue;
            CraftingResult craftingResult = variant.getCraftingResult();
            ItemStack outputStack = craftingResult.getResultStack();
            if (craftingResult != CraftingResult.EMPTY && outputStack != null) {
                OreDictPrefix prefix;
                String oreName;
                ItemStack ore;
                Block growthBlock;
                OreDictPrefix recipe = craftingResult.getOreDictPrefix();
                String[] customRecipe = craftingResult.getCustomRecipePattern();
                Block block = growthBlock = variant.getBlockToGrow() == null ? Blocks.field_150348_b : variant.getBlockToGrow().func_177230_c();
                if (customRecipe != null && customRecipe.length > 0) {
                    GameRegistry.addRecipe((IRecipe)new ShapedNBTRecipe(outputStack, customRecipe, Character.valueOf('*'), OreShrubHelper.instance().getBerries(variant), Character.valueOf('S'), growthBlock, Character.valueOf('#'), OreShrubHelper.instance().getCompressedBerries(variant)));
                } else if (recipe != OreDictPrefix.UNDEFINED) {
                    GameRegistry.addRecipe((IRecipe)new ShapedNBTRecipe(outputStack, recipe.getRecipePattern(), Character.valueOf('*'), OreShrubHelper.instance().getBerries(variant), Character.valueOf('S'), growthBlock, Character.valueOf('#'), OreShrubHelper.instance().getCompressedBerries(variant)));
                }
                if (craftingResult.shouldRegisterOreRecipe() && !craftingResult.getItemName().equals("") && (ore = ItemStackUtils.getFromOreDictName(oreName = (prefix = OreDictPrefix.getFromOreDictName(craftingResult.getItemName())) == OreDictPrefix.UNDEFINED ? OreDictPrefix.ORE.getName() + craftingResult.getItemName().substring(0, 1).toUpperCase() + craftingResult.getItemName().substring(1) : (prefix != OreDictPrefix.ORE ? craftingResult.getItemName().replaceFirst(prefix.getName(), OreDictPrefix.ORE.getName()) : ""))) != null) {
                    GameRegistry.addRecipe((IRecipe)new ShapedNBTRecipe(ore, OreDictPrefix.ORE.getRecipePattern(), Character.valueOf('S'), growthBlock, Character.valueOf('#'), OreShrubHelper.instance().getCompressedBerries(variant)));
                }
            }
            ItemStack compressedBerries = OreShrubHelper.instance().getCompressedBerries(variant);
            ItemStack normalBerries = OreShrubHelper.instance().getBerries(variant);
            GameRegistry.addRecipe((IRecipe)new ShapelessNBTRecipe(compressedBerries, normalBerries, normalBerries, normalBerries, normalBerries));
            ItemStack berries = OreShrubHelper.instance().getBerries(variant, 4);
            GameRegistry.addRecipe((IRecipe)new ShapelessNBTRecipe(berries, OreShrubHelper.instance().getCompressedBerries(variant)));
        }
    }

    private static void registerItemRecipes() {
        List allIngots;
        if (Configs.enableGrowingPowder) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ItemRegistry.itemShrubFertilizer, new Object[]{"MSM", "SBS", "MSM", Character.valueOf('S'), BlockRegistry.blockWitheredOreShrub, Character.valueOf('M'), new ItemStack(Items.field_151100_aR, 1, 15), Character.valueOf('B'), ItemRegistry.itemEmptyBag}));
            GameRegistry.addRecipe((IRecipe)new ShapedNBTRecipe(ItemRegistry.itemShrubFertilizer, "MSM", "SBS", "MSM", Character.valueOf('S'), ItemRegistry.itemOreBerries, Character.valueOf('M'), new ItemStack(Items.field_151100_aR, 1, 15), Character.valueOf('B'), ItemRegistry.itemEmptyBag));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ItemRegistry.itemEmptyBag, new Object[]{" S ", "L L", " L ", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('L'), Items.field_151116_aA}));
        if (OreShrubVariants.EXPERIENCE.getIsEnabled() && Configs.enableExperienceBottleRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapedNBTRecipe(Items.field_151062_by, "B B", " W ", "   ", Character.valueOf('B'), OreShrubHelper.instance().getBerries(OreShrubVariants.EXPERIENCE), Character.valueOf('W'), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b)));
        }
        if (Configs.enableShrubTrapRecipe) {
            ItemStack stack = Configs.enableForgottenShrineGeneration ? new ItemStack((Item)ItemRegistry.itemRandomBerries) : OreShrubHelper.instance().getBerries(OreShrubVariants.EXPERIENCE);
            GameRegistry.addRecipe((IRecipe)new ShapedNBTRecipe(BlockRegistry.blockShrubTrap, "RPR", "PWP", "SSS", Character.valueOf('S'), BlockRegistry.blockWitheredOreShrub, Character.valueOf('P'), Items.field_179562_cC, Character.valueOf('R'), stack, Character.valueOf('W'), new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE)));
        }
        if (Configs.enableShrubTrapWitherProofRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)BlockRegistry.blockShrubTrapWitherProof, new Object[]{"OWO", "WTW", "OWO", Character.valueOf('T'), BlockRegistry.blockShrubTrap, Character.valueOf('W'), new ItemStack(Items.field_151144_bL, 1, 1), Character.valueOf('O'), Blocks.field_150343_Z}));
        }
        if (OreShrubVariants.URANIUM.getIsEnabled() && Configs.enableExtraYellorumRecipe && OreDictionary.doesOreNameExist((String)"ingotYellorium") && (allIngots = OreDictionary.getOres((String)"ingotYellorium")).size() > 0) {
            GameRegistry.addRecipe((IRecipe)new ShapedNBTRecipe((ItemStack)allIngots.get(0), "BBB", "BCB", "BBB", Character.valueOf('B'), OreShrubHelper.instance().getBerries(OreShrubVariants.URANIUM), Character.valueOf('C'), "ingotGraphite"));
        }
    }
}

