/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import lhykos.oreshrubs.OreShrubs;
import lhykos.oreshrubs.api.oreshrub.GenerationSettings;
import lhykos.oreshrubs.api.oreshrub.VeinShape;
import lhykos.oreshrubs.common.helper.JsonHelper;
import net.minecraft.util.JsonUtils;
import net.minecraft.world.biome.Biome;

public class SerializerGenerationSettings
implements JsonDeserializer<GenerationSettings> {
    public GenerationSettings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)json, (String)"generation settings");
        if (jsonObject.entrySet().isEmpty()) {
            return GenerationSettings.EMPTY;
        }
        int dimension = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dimension", (int)0);
        int density = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"density", (int)1);
        int minGenHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"min_generation_height", (int)1);
        int maxGenHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"max_generation_height", (int)60);
        int veinSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"vein_size", (int)4);
        VeinShape veinShape = VeinShape.getFromString(JsonHelper.getString(jsonObject, "vein_shape", "NORMAL"));
        ArrayList<Biome> spawnBiomes = new ArrayList<Biome>();
        for (JsonElement element : JsonHelper.getJsonArray(jsonObject, "spawn_biomes", new JsonArray())) {
            Biome biome = null;
            try {
                biome = JsonHelper.getBiome(element, "", null);
            }
            catch (JsonSyntaxException e) {
                OreShrubs.LOGGER.warn("Found unknown biome while register custom shrub.");
            }
            if (biome == null) continue;
            spawnBiomes.add(biome);
        }
        return new GenerationSettings(dimension, density, minGenHeight, maxGenHeight, veinSize, veinShape, spawnBiomes);
    }
}

