/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import lhykos.oreshrubs.api.oreshrub.CraftingResult;
import lhykos.oreshrubs.api.oreshrub.GenerationSettings;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.common.helper.JsonHelper;
import lhykos.oreshrubs.common.util.ParsingUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;

public class SerializerOreShrubVariant
implements JsonDeserializer<OreShrubVariant> {
    public OreShrubVariant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)json, (String)"custom shrub");
        boolean isEnabled = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"enabled", (boolean)false);
        String registryName = JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"registry_name");
        String customDisplayName = JsonHelper.getString(jsonObject, "custom_display_name", null);
        int rarity = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"rarity", (int)5);
        int shrubColor = ParsingUtils.parseIntegerFromString(JsonHelper.getString(jsonObject, "shrub_color", "0xFFFFFF"), 0xFFFFFF);
        int berryColor = ParsingUtils.parseIntegerFromString(JsonHelper.getString(jsonObject, "berry_color", "0xFFFFFF"), 0xFFFFFF);
        int growthChance = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"growth_chance", (int)20);
        int maxHarvestedBerries = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"max_harvested_berries", (int)4);
        int lightLevel = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"light_level", (int)0);
        int maxGrowthLight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"max_growth_light", (int)10);
        IBlockState growthBlock = null;
        Block block = JsonHelper.getBlock(jsonObject, "growth_block", null);
        if (block != null) {
            growthBlock = block.func_176223_P();
        }
        GenerationSettings generationSettings = (GenerationSettings)JsonUtils.func_188177_a((JsonObject)jsonObject, (String)"generation_settings", (Object)GenerationSettings.EMPTY, (JsonDeserializationContext)context, GenerationSettings.class);
        CraftingResult craftingResult = (CraftingResult)JsonUtils.func_188177_a((JsonObject)jsonObject, (String)"crafting_result", (Object)CraftingResult.EMPTY, (JsonDeserializationContext)context, CraftingResult.class);
        return new OreShrubVariant(registryName, rarity, growthChance, maxHarvestedBerries, lightLevel, maxGrowthLight, shrubColor, berryColor){

            @Override
            public boolean isConfigurable() {
                return false;
            }
        }.setCraftingResult(craftingResult).setGenerationSettings(generationSettings).setIsEnabled(isEnabled).setCustomDisplayName(customDisplayName).setGrowthBlock(growthBlock);
    }
}

