/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.util;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackUtils {
    public static final UUID ATTACK_DAMAGE_MODIFIER_ID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    public static final UUID ATTACK_SPEED_MODIFIER_ID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    public static double getAttackSpeed(ItemStack stack, EntityEquipmentSlot equipSlot) {
        return ItemStackUtils.getAttributeModifierAmount(stack, equipSlot, ATTACK_SPEED_MODIFIER_ID);
    }

    public static double getAttackDamage(ItemStack stack, EntityEquipmentSlot equipSlot) {
        return ItemStackUtils.getAttributeModifierAmount(stack, equipSlot, ATTACK_DAMAGE_MODIFIER_ID);
    }

    public static double getAttributeModifierAmount(ItemStack stack, EntityEquipmentSlot equipSlot, UUID attributeID) {
        if (stack != null) {
            Multimap multiMap = stack.func_77973_b().getAttributeModifiers(equipSlot, stack);
            for (Map.Entry entry : multiMap.entries()) {
                AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                if (!attributeModifier.func_111167_a().equals(attributeID)) continue;
                return attributeModifier.func_111164_d();
            }
        }
        return 0.0;
    }

    public static void spawnItemStackInWorld(World world, BlockPos pos, ItemStack stack) {
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack getFromOreDictName(String oreDictName) {
        try {
            if (OreDictionary.doesOreNameExist((String)oreDictName)) {
                return (ItemStack)OreDictionary.getOres((String)oreDictName).get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemStack getFromItemName(String itemName, int size, int meta) {
        try {
            ResourceLocation resourceLocation = new ResourceLocation(itemName);
            Item item = null;
            if (ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
                item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            }
            if (item != null) {
                return new ItemStack(item, size, meta);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

