/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.util.nbt;

import lhykos.oreshrubs.common.util.nbt.NBTUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class NBTItemUtils {
    public static NBTTagCompound getStackNBT(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean hasTag(ItemStack stack, String key) {
        return NBTItemUtils.getStackNBT(stack).func_74764_b(key);
    }

    public static boolean isValid(ItemStack stack, String key) {
        return stack != null && NBTItemUtils.hasTag(stack, key);
    }

    public static void writeBoolean(ItemStack stack, String key, boolean value) {
        NBTItemUtils.getStackNBT(stack).func_74757_a(key, value);
    }

    public static boolean readBoolean(ItemStack stack, String key, boolean fallback) {
        return NBTItemUtils.isValid(stack, key) ? NBTItemUtils.getStackNBT(stack).func_74767_n(key) : fallback;
    }

    public static void writeInteger(ItemStack stack, String key, int value) {
        NBTItemUtils.getStackNBT(stack).func_74768_a(key, value);
    }

    public static int readInteger(ItemStack stack, String key, int fallback) {
        return NBTItemUtils.isValid(stack, key) ? NBTItemUtils.getStackNBT(stack).func_74762_e(key) : fallback;
    }

    public static void writeByte(ItemStack stack, String key, byte value) {
        NBTItemUtils.getStackNBT(stack).func_74774_a(key, value);
    }

    public static byte readByte(ItemStack stack, String key, byte fallback) {
        return NBTItemUtils.isValid(stack, key) ? NBTItemUtils.getStackNBT(stack).func_74771_c(key) : fallback;
    }

    public static void writeFloat(ItemStack stack, String key, float value) {
        NBTItemUtils.getStackNBT(stack).func_74776_a(key, value);
    }

    public static float readFloat(ItemStack stack, String key, float fallback) {
        return NBTItemUtils.isValid(stack, key) ? NBTItemUtils.getStackNBT(stack).func_74760_g(key) : fallback;
    }

    public static void writeDouble(ItemStack stack, String key, double value) {
        NBTItemUtils.getStackNBT(stack).func_74780_a(key, value);
    }

    public static double readDouble(ItemStack stack, String key, double fallback) {
        return NBTItemUtils.isValid(stack, key) ? NBTItemUtils.getStackNBT(stack).func_74769_h(key) : fallback;
    }

    public static void writeString(ItemStack stack, String key, String value) {
        NBTItemUtils.getStackNBT(stack).func_74778_a(key, value);
    }

    public static String readString(ItemStack stack, String key, String fallback) {
        return NBTItemUtils.isValid(stack, key) ? NBTItemUtils.getStackNBT(stack).func_74779_i(key) : fallback;
    }

    public static void writeCompound(ItemStack stack, String key, NBTTagCompound value) {
        NBTItemUtils.getStackNBT(stack).func_74782_a(key, (NBTBase)value);
    }

    public static NBTTagCompound readCompound(ItemStack stack, String key) {
        return NBTItemUtils.getStackNBT(stack).func_74775_l(key);
    }

    public static void writeTagList(ItemStack stack, String key, NBTTagList value) {
        NBTItemUtils.getStackNBT(stack).func_74782_a(key, (NBTBase)value);
    }

    public static NBTTagList readTagList(ItemStack stack, String key, int type) {
        return NBTItemUtils.getStackNBT(stack).func_150295_c(key, type);
    }

    public static void writeBlockPos(ItemStack stack, String key, BlockPos value) {
        NBTUtils.writeBlockPos(NBTItemUtils.getStackNBT(stack), key, value);
    }

    public static BlockPos readBlockPos(ItemStack stack, String key, BlockPos fallback) {
        return NBTItemUtils.isValid(stack, key) ? NBTUtils.readBlockPos(NBTItemUtils.getStackNBT(stack), key) : fallback;
    }

    public static void writeBlockState(ItemStack stack, String key, IBlockState value) {
        NBTItemUtils.getStackNBT(stack).func_74782_a(key, (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)value));
    }

    public static IBlockState readBlockState(ItemStack stack, String key) {
        return NBTUtil.func_190008_d((NBTTagCompound)NBTItemUtils.getStackNBT(stack).func_74775_l(key));
    }

    public static void writeTileEntityNBT(ItemStack stack, TileEntity tileEntity, String key) {
        if (tileEntity != null && stack != null) {
            NBTTagCompound tileNBT = tileEntity.func_189515_b(new NBTTagCompound());
            tileNBT.func_82580_o("x");
            tileNBT.func_82580_o("y");
            tileNBT.func_82580_o("z");
            NBTItemUtils.getStackNBT(stack).func_74782_a(key, (NBTBase)tileNBT);
        }
    }

    public static NBTTagCompound readTileEntityNBT(ItemStack stack, TileEntity tileEntity, String key) {
        if (tileEntity != null && stack != null) {
            NBTTagCompound tileNBT = NBTItemUtils.getStackNBT(stack).func_74775_l(key);
            tileNBT.func_74768_a("x", tileEntity.func_174877_v().func_177958_n());
            tileNBT.func_74768_a("y", tileEntity.func_174877_v().func_177956_o());
            tileNBT.func_74768_a("z", tileEntity.func_174877_v().func_177952_p());
            return tileNBT;
        }
        return new NBTTagCompound();
    }
}

