/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.world.gen;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lhykos.oreshrubs.api.OreShrubVariants;
import lhykos.oreshrubs.api.oreshrub.GenerationSettings;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.api.oreshrub.VeinShape;
import lhykos.oreshrubs.common.block.BlockOreShrub;
import lhykos.oreshrubs.common.config.Configs;
import lhykos.oreshrubs.common.helper.OreShrubHelper;
import lhykos.oreshrubs.common.registry.OreShrubRegistry;
import lhykos.oreshrubs.common.world.gen.VeinGeneration;
import lhykos.oreshrubs.common.world.gen.structure.StructureForgottenShrine;
import lhykos.oreshrubs.common.world.storage.OreShrubsWorldData;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreShrubsWorldGenerator
implements IWorldGenerator {
    public static final OreShrubsWorldGenerator INSTANCE = new OreShrubsWorldGenerator();
    public static Map<Integer, List<ChunkPos>> forgottenShrineChunks = new HashMap<Integer, List<ChunkPos>>();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                if (!Configs.enableForgottenShrineGeneration) break;
                this.generateForgottenShrine(world, random, chunkX, chunkZ);
                break;
            }
            case -1: {
                break;
            }
            case 1: {
                break;
            }
        }
        if (Configs.enableOreShrubGeneration && world.func_175624_G() != WorldType.field_77138_c) {
            this.generateOreShrubs(world, random, chunkX, chunkZ);
        }
    }

    public NBTTagCompound saveToNBT(NBTTagCompound compound) {
        NBTTagList whiteShrineNBT = new NBTTagList();
        for (int dimension : forgottenShrineChunks.keySet()) {
            NBTTagCompound dimensionNBT = new NBTTagCompound();
            dimensionNBT.func_74768_a("Id", dimension);
            NBTTagList chunkList = new NBTTagList();
            for (ChunkPos chunkPos : forgottenShrineChunks.get(dimension)) {
                NBTTagCompound chunkNBT = new NBTTagCompound();
                chunkNBT.func_74768_a("X", chunkPos.field_77276_a);
                chunkNBT.func_74768_a("Z", chunkPos.field_77275_b);
                chunkList.func_74742_a((NBTBase)chunkNBT);
            }
            dimensionNBT.func_74782_a("ChunkList", (NBTBase)chunkList);
            whiteShrineNBT.func_74742_a((NBTBase)dimensionNBT);
        }
        compound.func_74782_a("ForgottenShrineChunks", (NBTBase)whiteShrineNBT);
        return compound;
    }

    public void loadFromNBT(World world, NBTTagCompound compound) {
        forgottenShrineChunks = new HashMap<Integer, List<ChunkPos>>();
        NBTTagList whiteShrineNBT = compound.func_150295_c("ForgottenShrineChunks", 10);
        for (int i = 0; i < whiteShrineNBT.func_74745_c(); ++i) {
            NBTTagCompound dimensionNBT = whiteShrineNBT.func_150305_b(i);
            int dimension = dimensionNBT.func_74762_e("Id");
            NBTTagList chunkList = dimensionNBT.func_150295_c("ChunkList", 10);
            for (int j = 0; j < chunkList.func_74745_c(); ++j) {
                NBTTagCompound chunkNBT = chunkList.func_150305_b(j);
                ChunkPos chunkPos = new ChunkPos(chunkNBT.func_74762_e("X"), chunkNBT.func_74762_e("Z"));
                this.addToGeneratedChunks(world, chunkPos, false);
            }
        }
    }

    private void generateForgottenShrine(World world, Random random, int chunkX, int chunkZ) {
        int z;
        int dimension = world.field_73011_w.getDimension();
        int x = chunkX * 16 + random.nextInt(16);
        BlockPos pos = new BlockPos(x, 0, z = chunkZ * 16 + random.nextInt(16));
        Biome biome = world.func_180494_b(pos);
        if (biome != Biomes.field_76771_b && biome != Biomes.field_150575_M && biome != Biomes.field_76781_i && biome != Biomes.field_76776_l && biome != Biomes.field_76777_m && biome.func_150561_m() != Biome.TempCategory.OCEAN) {
            BlockPos structureStart;
            int genHeight;
            if (forgottenShrineChunks.size() == 0) {
                ChunkPos spawnChunk = world.func_175726_f(world.func_175694_M()).func_76632_l();
                this.addToGeneratedChunks(world, spawnChunk, true);
            }
            if (this.isSingleShrineInRange(dimension, chunkX, chunkZ) && (genHeight = this.getGenerationHeight(world, x, z, 60, 256, 6)) != -1 && this.canStructurePlaceHere(world, (structureStart = new BlockPos(x, genHeight, z)).func_177982_a(0, 1, 0), structureStart.func_177982_a(7, 9, 7)) && this.hasValidGround(world, structureStart, structureStart.func_177982_a(7, 0, 7))) {
                StructureForgottenShrine structureForgottenShrine = new StructureForgottenShrine();
                structureForgottenShrine.setupStructure(structureStart.func_177982_a(0, 1, 0), EnumFacing.NORTH);
                structureForgottenShrine.func_74875_a(world, random, structureForgottenShrine.func_74874_b());
                this.addToGeneratedChunks(world, new ChunkPos(chunkX, chunkZ), true);
            }
        }
    }

    private boolean hasValidGround(World world, BlockPos from, BlockPos to) {
        Iterable toCheck = BlockPos.func_177980_a((BlockPos)from, (BlockPos)to);
        for (BlockPos pos : toCheck) {
            if (this.isSolidBlock(world.func_180495_p(pos))) continue;
            return false;
        }
        return true;
    }

    private boolean canStructurePlaceHere(World world, BlockPos sStart, BlockPos sEnd) {
        Iterable toCheck = BlockPos.func_177980_a((BlockPos)sStart, (BlockPos)sEnd);
        for (BlockPos pos : toCheck) {
            if (!this.isSolidBlock(world.func_180495_p(pos))) continue;
            return false;
        }
        return true;
    }

    private int getGenerationHeight(World world, int x, int z, int yMin, int yMax, int structureHeight) {
        if (yMin < yMax - structureHeight) {
            for (int i = yMax - structureHeight; i > yMin; --i) {
                BlockPos pos = new BlockPos(x, i, z);
                if (!this.isSolidBlock(world.func_180495_p(pos)) || !world.func_175623_d(pos.func_177984_a())) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean isSolidBlock(IBlockState state) {
        Material material = state.func_185904_a();
        return material.func_76220_a() && material.func_76218_k();
    }

    private void addToGeneratedChunks(World world, ChunkPos pos, boolean isNew) {
        int dimension = world.field_73011_w.getDimension();
        if (forgottenShrineChunks.containsKey(dimension)) {
            if (!forgottenShrineChunks.get(dimension).contains(pos)) {
                forgottenShrineChunks.get(dimension).add(pos);
            }
        } else {
            forgottenShrineChunks.put(dimension, Lists.newArrayList((Object[])new ChunkPos[]{pos}));
        }
        if (isNew) {
            OreShrubsWorldData.get(world).writeToWorldData("GeneratedForgottenShrines", this.saveToNBT(new NBTTagCompound()));
        }
    }

    private boolean isSingleShrineInRange(int dimension, int chunkX, int chunkZ) {
        int distance = Configs.forgottenShrineMinChunkDistance;
        for (ChunkPos chunkPos : forgottenShrineChunks.get(dimension)) {
            int i0 = chunkPos.field_77276_a - chunkX;
            int i1 = chunkPos.field_77275_b - chunkZ;
            int i = (int)Math.sqrt(i0 * i0 + i1 * i1);
            if (i >= distance) continue;
            distance = i;
        }
        return distance >= Configs.forgottenShrineMinChunkDistance;
    }

    private void generateOreShrubs(World world, Random rand, int chunkX, int chunkZ) {
        for (OreShrubVariant variant : OreShrubRegistry.instance().getAll()) {
            if (!variant.getIsEnabled() || !variant.canGenerateShrubs()) continue;
            GenerationSettings genSettings = variant.getGenerationSettings();
            if (world.field_73011_w.getDimension() != genSettings.getDimension()) continue;
            for (int i = 0; i < genSettings.getDensity(); ++i) {
                int z;
                int x;
                int y;
                int rarity = variant.getRarity();
                if (world.func_180494_b(new BlockPos(chunkX, 0, chunkZ)) == Biomes.field_150589_Z && variant == OreShrubVariants.EXPERIENCE) {
                    rarity = Math.round(rarity / 2);
                }
                if (rand.nextInt(rarity) != 0 || (y = this.getOreShrubSpawnHeight(world, rand, x = chunkX * 16 + rand.nextInt(16), z = chunkZ * 16 + rand.nextInt(16), variant)) == -1) continue;
                VeinGeneration.generateVein(world, rand, new BlockPos(x, y, z), variant);
            }
        }
    }

    private int getOreShrubSpawnHeight(World world, Random rand, int x, int z, OreShrubVariant variant) {
        GenerationSettings genSettings = variant.getGenerationSettings();
        BlockOreShrub shrub = (BlockOreShrub)Block.func_149634_a((Item)OreShrubHelper.instance().getShrub(variant).func_77973_b());
        int baseHeight = genSettings.getDimension() == 0 ? world.func_181545_F() : 128;
        VeinShape veinShape = genSettings.getVeinShape();
        for (int y = Math.min(baseHeight - 4, genSettings.getMaxGenHeight()); y >= genSettings.getMinGenHeight(); --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (world.func_180495_p(pos).func_185904_a() != Material.field_151579_a) continue;
            if (veinShape != VeinShape.PILLAR_DOWN && shrub.canSurviveAt(world, pos, variant, false) && rand.nextBoolean()) {
                return y;
            }
            if (veinShape == VeinShape.PILLAR_UP || !shrub.canSurviveAt(world, pos, variant, true) || !rand.nextBoolean()) continue;
            return y;
        }
        return -1;
    }
}

