/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.world.gen;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import lhykos.oreshrubs.OreShrubs;
import lhykos.oreshrubs.common.config.Configs;
import lhykos.oreshrubs.common.world.gen.OreShrubsWorldGenerator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public class Retrogen {
    private static final String OS_DATA = "OreShrubsChunkData";
    private static HashMap<Integer, Queue<ChunkPos>> chunkRetroMap;
    private static int tick;

    @SubscribeEvent
    public static void onChunkLoad(ChunkDataEvent.Load event) {
        NBTTagCompound osData = event.getData().func_74775_l(OS_DATA);
        int dimension = event.getWorld().field_73011_w.getDimension();
        if (Configs.enableOreShrubsRetrogen && osData.func_74762_e("OreShrubs_GenVersion") < 1) {
            Retrogen.addRetrogenChunk(dimension, event.getChunk().func_76632_l());
        }
    }

    @SubscribeEvent
    public static void onChunkSave(ChunkDataEvent.Save event) {
        NBTTagCompound osData = event.getData().func_74775_l(OS_DATA);
        osData.func_74768_a("OreShrubs_GenVersion", 1);
        event.getData().func_74782_a(OS_DATA, (NBTBase)osData);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END && chunkRetroMap != null) {
            World world = event.world;
            int dimension = world.field_73011_w.getDimension();
            Queue<ChunkPos> chunks = chunkRetroMap.get(dimension);
            if (chunks != null && chunks.size() > 0) {
                ChunkPos chunkPos = chunks.poll();
                long worldSeed = world.func_72905_C();
                Random random = new Random(worldSeed);
                long xSeed = random.nextLong() >> 3;
                long zSeed = random.nextLong() >> 3;
                random.setSeed(xSeed * (long)chunkPos.field_77276_a + zSeed * (long)chunkPos.field_77275_b ^ worldSeed);
                if (tick++ % 20 == 0) {
                    OreShrubs.LOGGER.info("Retroactive ore shrub generation in dimension [" + world.field_73011_w.getDimension() + "] for chunk " + chunkPos.toString());
                }
                OreShrubsWorldGenerator.INSTANCE.generate(random, chunkPos.field_77276_a, chunkPos.field_77275_b, world, world.field_73011_w.func_186060_c(), world.func_72863_F());
            }
            if (chunks != null && chunks.isEmpty()) {
                chunkRetroMap.remove(dimension);
            }
        }
    }

    private static void addRetrogenChunk(int dimension, ChunkPos chunkPos) {
        if (chunkRetroMap == null) {
            chunkRetroMap = new HashMap();
        }
        if (!chunkRetroMap.containsKey(dimension)) {
            LinkedList<ChunkPos> chunks = new LinkedList<ChunkPos>();
            chunks.add(chunkPos);
            chunkRetroMap.put(dimension, chunks);
        } else if (!chunkRetroMap.get(dimension).contains(chunkPos)) {
            chunkRetroMap.get(dimension).add(chunkPos);
        }
    }

    static {
        tick = 0;
    }
}

