/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.world.gen;

import java.util.Random;
import lhykos.oreshrubs.api.oreshrub.GenerationSettings;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.common.block.BlockOreShrub;
import lhykos.oreshrubs.common.helper.OreShrubHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class VeinGeneration {
    public static boolean generateVein(World world, Random random, BlockPos pos, OreShrubVariant variant) {
        Biome currentBiome = world.func_180494_b(pos);
        boolean isInBiome = variant.getGenerationSettings().getSpawnBiomes().size() == 0 || variant.getGenerationSettings().getSpawnBiomes().stream().anyMatch(biome -> biome == currentBiome);
        GenerationSettings settings = variant.getGenerationSettings();
        if (isInBiome) {
            switch (settings.getVeinShape()) {
                case NORMAL: {
                    return VeinGeneration.generateNormal(world, random, pos, variant);
                }
                case PILLAR_UP: {
                    return VeinGeneration.generatePillar(world, random, pos, variant, false);
                }
                case PILLAR_DOWN: {
                    return VeinGeneration.generatePillar(world, random, pos, variant, true);
                }
            }
            return false;
        }
        return false;
    }

    private static boolean generateNormal(World world, Random random, BlockPos pos, OreShrubVariant variant) {
        int generated = 0;
        GenerationSettings settings = variant.getGenerationSettings();
        for (int i = 0; i < settings.getMaxVeinSize() * 2; ++i) {
            BlockPos pos1 = pos.func_177982_a(random.nextInt(3) + -1, random.nextInt(3) + -1, random.nextInt(3) + -1);
            IBlockState state = world.func_180495_p(pos1);
            if (state.func_185904_a() == Material.field_151579_a) {
                BlockOreShrub shrub = (BlockOreShrub)Block.func_149634_a((Item)OreShrubHelper.instance().getShrub(variant).func_77973_b());
                if (generated == 0) {
                    if (VeinGeneration.generateShrubBlock(world, pos, state, variant)) {
                        ++generated;
                    }
                } else if (shrub.hasValidPlace(world, pos1, true) && VeinGeneration.generateShrubBlock(world, pos1, state, variant)) {
                    ++generated;
                }
            }
            if (generated < settings.getMaxVeinSize()) continue;
            return true;
        }
        return generated > 0;
    }

    private static boolean generatePillar(World world, Random random, BlockPos pos, OreShrubVariant variant, boolean inverted) {
        int generated = 0;
        for (int i = 0; i < variant.getGenerationSettings().getMaxVeinSize(); ++i) {
            IBlockState placeState = world.func_180495_p(pos);
            BlockOreShrub shrub = (BlockOreShrub)Block.func_149634_a((Item)OreShrubHelper.instance().getShrub(variant).func_77973_b());
            if (placeState.func_185904_a() == Material.field_151579_a) {
                if (i == 0) {
                    if (VeinGeneration.generateShrubBlock(world, pos, placeState, variant)) {
                        ++generated;
                    }
                } else if (random.nextBoolean() && shrub.canSurviveAt(world, pos, variant, inverted) && VeinGeneration.generateShrubBlock(world, pos, placeState, variant)) {
                    ++generated;
                }
            }
            pos = inverted ? pos.func_177977_b() : pos.func_177984_a();
        }
        return generated > 0;
    }

    private static boolean generateShrubBlock(World world, BlockPos pos, IBlockState state, OreShrubVariant variant) {
        BlockOreShrub shrub;
        if (state.func_177230_c().func_176200_f((IBlockAccess)world, pos) && (shrub = (BlockOreShrub)Block.func_149634_a((Item)OreShrubHelper.instance().getShrub(variant).func_77973_b())) != Blocks.field_150350_a) {
            return world.func_180501_a(pos, shrub.func_176223_P().func_177226_a((IProperty)BlockOreShrub.AGE, (Comparable)Integer.valueOf(3)), 2);
        }
        return false;
    }
}

