/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.world.storage.loot.functions;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lhykos.oreshrubs.api.LootBagVariants;
import lhykos.oreshrubs.api.lootbag.LootBagVariant;
import lhykos.oreshrubs.common.helper.LootBagHelper;
import lhykos.oreshrubs.common.registry.LootBagRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;

public class LootFunctionRandomLootBag
extends LootFunction {
    private final List<LootBagVariant> bagTypes;

    public LootFunctionRandomLootBag(LootCondition[] conditionsIn, List<LootBagVariant> bagTypes) {
        super(conditionsIn);
        this.bagTypes = bagTypes;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (this.bagTypes != null && !this.bagTypes.isEmpty()) {
            LootBagVariant bagType = this.bagTypes.get(rand.nextInt(this.bagTypes.size()));
            LootBagHelper.instance().initializeLootBag(stack, bagType);
            if (rand.nextInt(bagType.getRarity() * 2) == 0) {
                LootBagHelper.instance().makeAdvanced(stack);
            }
        }
        return stack;
    }

    static {
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new Serializer());
    }

    public static class Serializer
    extends LootFunction.Serializer<LootFunctionRandomLootBag> {
        public Serializer() {
            super(new ResourceLocation("random_lootbag"), LootFunctionRandomLootBag.class);
        }

        public void serialize(JsonObject object, LootFunctionRandomLootBag functionClazz, JsonSerializationContext serializationContext) {
            if (functionClazz.bagTypes != null && !functionClazz.bagTypes.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (LootBagVariant bagType : functionClazz.bagTypes) {
                    if (!bagType.getIsEnabled() || bagType == LootBagVariants.EMPTY) {
                        throw new IllegalArgumentException("Can't serialize loot bag lootbag: " + bagType.getRegistryName());
                    }
                    jsonArray.add((JsonElement)new JsonPrimitive("lootbag" + bagType.getRegistryName()));
                }
                object.add("lootbag_types", (JsonElement)jsonArray);
            }
        }

        public LootFunctionRandomLootBag deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            ArrayList bagTypes = null;
            if (object.has("lootbag_types")) {
                bagTypes = Lists.newArrayList();
                for (JsonElement element : JsonUtils.func_151214_t((JsonObject)object, (String)"lootbag_types")) {
                    String registryName = JsonUtils.func_151206_a((JsonElement)element, (String)"lootbag");
                    LootBagVariant bagType = LootBagRegistry.instance().getFromRegistryName(registryName);
                    if (bagType == LootBagVariants.EMPTY) {
                        throw new JsonSyntaxException("Unknown loot bag lootbag '" + registryName + "'");
                    }
                    bagTypes.add(bagType);
                }
            }
            return new LootFunctionRandomLootBag(conditionsIn, bagTypes);
        }
    }
}

