/*
 * Decompiled with CFR 0.152.
 */
package lhykos.oreshrubs.common.world.storage.loot.functions;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lhykos.oreshrubs.api.OreShrubVariants;
import lhykos.oreshrubs.api.oreshrub.OreShrubVariant;
import lhykos.oreshrubs.common.helper.OreShrubHelper;
import lhykos.oreshrubs.common.registry.OreShrubRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;

public class LootFunctionRandomOreShrub
extends LootFunction {
    private final List<OreShrubVariant> oreShrubVariants;
    private final boolean getBerries;

    public LootFunctionRandomOreShrub(LootCondition[] conditionsIn, List<OreShrubVariant> oreShrubVariants, boolean getBerries) {
        super(conditionsIn);
        this.oreShrubVariants = oreShrubVariants;
        this.getBerries = getBerries;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        OreShrubVariant tmpType;
        OreShrubVariant variant = OreShrubVariants.EMPTY;
        if (this.oreShrubVariants != null && !this.oreShrubVariants.isEmpty() && (tmpType = this.oreShrubVariants.get(rand.nextInt(this.oreShrubVariants.size()))).getIsEnabled()) {
            variant = tmpType;
        }
        if (variant != OreShrubVariants.EMPTY) {
            if (!this.getBerries) {
                stack = OreShrubHelper.instance().getShrub(variant, stack.field_77994_a);
            } else {
                OreShrubHelper.instance().setVariantToBerries(stack, variant);
            }
        }
        return stack;
    }

    static {
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new Serializer());
    }

    public static class Serializer
    extends LootFunction.Serializer<LootFunctionRandomOreShrub> {
        public Serializer() {
            super(new ResourceLocation("random_oreshrub"), LootFunctionRandomOreShrub.class);
        }

        public void serialize(JsonObject object, LootFunctionRandomOreShrub functionClazz, JsonSerializationContext serializationContext) {
            object.add("getBerries", serializationContext.serialize((Object)functionClazz.getBerries));
            if (functionClazz.oreShrubVariants != null && !functionClazz.oreShrubVariants.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (OreShrubVariant oreShrubVariant : functionClazz.oreShrubVariants) {
                    if (!oreShrubVariant.getIsEnabled() || oreShrubVariant == OreShrubVariants.EMPTY) {
                        throw new IllegalArgumentException("Can't serialize shrub lootbag: " + oreShrubVariant.getRegistryName());
                    }
                    jsonArray.add((JsonElement)new JsonPrimitive("oreShrubVariant" + oreShrubVariant.getRegistryName()));
                }
                object.add("oreshrub_types", (JsonElement)jsonArray);
            }
        }

        public LootFunctionRandomOreShrub deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            boolean getBerries = JsonUtils.func_151212_i((JsonObject)object, (String)"getBerries");
            ArrayList oreShrubVariants = null;
            if (object.has("oreshrub_types")) {
                oreShrubVariants = Lists.newArrayList();
                for (JsonElement element : JsonUtils.func_151214_t((JsonObject)object, (String)"oreshrub_types")) {
                    String registryName = JsonUtils.func_151206_a((JsonElement)element, (String)"oreShrubVariant");
                    OreShrubVariant oreShrubVariant = OreShrubRegistry.instance().getFromRegistryName(registryName);
                    if (oreShrubVariant == OreShrubVariants.EMPTY) {
                        throw new JsonSyntaxException("Unknown shrub lootbag '" + registryName + "'");
                    }
                    oreShrubVariants.add(oreShrubVariant);
                }
            }
            return new LootFunctionRandomOreShrub(conditionsIn, oreShrubVariants, getBerries);
        }
    }
}

