/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.minecraft;

import java.lang.reflect.Method;
import java.util.List;
import mcp.mobius.waila.addons.HUDHandlerBase;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.cbcore.LangUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class HUDHandlerVanilla
extends HUDHandlerBase {
    static Method getCrop;
    static Block mobSpawner;
    static Block crops;
    static Block beet;
    static Block farmland;
    static Block melonStem;
    static Block pumpkinStem;
    static Block lever;
    static Block repeaterIdle;
    static Block repeaterActv;
    static Block comparatorIdl;
    static Block comparatorAct;
    static Block redstone;
    static Block jukebox;
    static Block cocoa;
    static Block netherwart;
    static Block silverfish;
    static Block flowerpot;

    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (block == silverfish && config.getConfig("vanilla.silverfish")) {
            int metadata = accessor.getMetadata();
            switch (metadata) {
                case 0: {
                    return new ItemStack(Blocks.field_150348_b);
                }
                case 1: {
                    return new ItemStack(Blocks.field_150347_e);
                }
                case 2: {
                    return new ItemStack(Blocks.field_150336_V);
                }
            }
            return null;
        }
        if (block == flowerpot) {
            int x = accessor.getPosition().func_177958_n();
            int y = accessor.getPosition().func_177956_o();
            int z = accessor.getPosition().func_177952_p();
            if (!accessor.getWorld().func_180495_p(new BlockPos(x, y, z)).func_177227_a().contains(BlockFlowerPot.field_176443_b)) {
                return new ItemStack(Blocks.field_150457_bL, 1, accessor.getMetadata());
            }
            BlockFlowerPot.EnumFlowerType variant = (BlockFlowerPot.EnumFlowerType)accessor.getWorld().func_180495_p(new BlockPos(x, y, z)).func_177229_b((IProperty)BlockFlowerPot.field_176443_b);
            switch (variant) {
                case ACACIA_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 4);
                }
                case ALLIUM: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 2);
                }
                case BIRCH_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 2);
                }
                case BLUE_ORCHID: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 1);
                }
                case CACTUS: {
                    return new ItemStack((Block)Blocks.field_150434_aF, 1, 0);
                }
                case DANDELION: {
                    return new ItemStack((Block)Blocks.field_150327_N, 1, 0);
                }
                case DARK_OAK_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 5);
                }
                case DEAD_BUSH: {
                    return new ItemStack((Block)Blocks.field_150329_H, 1, 0);
                }
                case EMPTY: {
                    return new ItemStack(Items.field_151162_bE, 1, 0);
                }
                case FERN: {
                    return new ItemStack((Block)Blocks.field_150329_H, 1, 2);
                }
                case HOUSTONIA: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 3);
                }
                case JUNGLE_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 3);
                }
                case MUSHROOM_BROWN: {
                    return new ItemStack((Block)Blocks.field_150338_P, 1, 0);
                }
                case MUSHROOM_RED: {
                    return new ItemStack((Block)Blocks.field_150337_Q, 1, 0);
                }
                case OAK_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 0);
                }
                case ORANGE_TULIP: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 5);
                }
                case OXEYE_DAISY: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 8);
                }
                case PINK_TULIP: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 7);
                }
                case POPPY: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 0);
                }
                case RED_TULIP: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 4);
                }
                case SPRUCE_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 1);
                }
                case WHITE_TULIP: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 6);
                }
            }
            return new ItemStack(Blocks.field_150457_bL);
        }
        if (config.getConfig("vanilla.alternatecropitem")) {
            if (block instanceof BlockCrops) {
                if (getCrop == null) {
                    getCrop = ReflectionHelper.findMethod(BlockCrops.class, null, (String[])new String[]{"getCrop", "func_149865_P"}, (Class[])new Class[0]);
                }
                try {
                    return new ItemStack((Item)getCrop.invoke((Object)block, new Object[0]), 1, block.func_180651_a(accessor.getBlockState()));
                }
                catch (Exception e) {
                    return null;
                }
            }
        } else {
            if (block == crops) {
                return new ItemStack(Items.field_151015_O);
            }
            if (block == beet) {
                return new ItemStack(Items.field_185164_cV);
            }
        }
        if (block == farmland) {
            return new ItemStack(Blocks.field_150458_ak);
        }
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String name;
        Block block = accessor.getBlock();
        if (block == mobSpawner && accessor.getTileEntity() instanceof TileEntityMobSpawner && config.getConfig("vanilla.spawntype")) {
            name = currenttip.get(0);
            String mobname = ((TileEntityMobSpawner)accessor.getTileEntity()).func_145881_a().func_184994_d().func_70005_c_();
            currenttip.set(0, String.format("%s (%s)", name, mobname));
        }
        if (block == redstone) {
            name = currenttip.get(0).replaceFirst(String.format(" %s", accessor.getMetadata()), "");
            currenttip.set(0, name);
        }
        if (block == melonStem) {
            currenttip.set(0, SpecialChars.WHITE + I18n.func_74838_a((String)"hud.item.melonstem"));
        }
        if (block == pumpkinStem) {
            currenttip.set(0, SpecialChars.WHITE + I18n.func_74838_a((String)"hud.item.pumpkinstem"));
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (config.getConfig("general.showcrop") && BlockCrops.class.isInstance(block)) {
            float growthValue = (float)accessor.getMetadata() / (float)((BlockCrops)block).func_185526_g() * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG("hud.msg.growth", new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.growth", new Object[0]), LangUtil.translateG("hud.msg.mature", new Object[0])));
            }
            return currenttip;
        }
        if (block == melonStem || block == pumpkinStem) {
            float growthValue = (float)accessor.getMetadata() / 7.0f * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG("hud.msg.growth", new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.growth", new Object[0]), LangUtil.translateG("hud.msg.mature", new Object[0])));
            }
            return currenttip;
        }
        if (block == cocoa && config.getConfig("general.showcrop")) {
            float growthValue = (float)(accessor.getMetadata() >> 2) / 2.0f * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG("hud.msg.growth", new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.growth", new Object[0]), LangUtil.translateG("hud.msg.mature", new Object[0])));
            }
            return currenttip;
        }
        if (block == netherwart && config.getConfig("general.showcrop")) {
            float growthValue = (float)accessor.getMetadata() / 3.0f * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG("hud.msg.growth", new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.growth", new Object[0]), LangUtil.translateG("hud.msg.mature", new Object[0])));
            }
            return currenttip;
        }
        if (config.getConfig("vanilla.leverstate") && block == lever) {
            String redstoneOn = (accessor.getMetadata() & 8) == 0 ? LangUtil.translateG("hud.msg.off", new Object[0]) : LangUtil.translateG("hud.msg.on", new Object[0]);
            currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.state", new Object[0]), redstoneOn));
            return currenttip;
        }
        if (config.getConfig("vanilla.repeater") && (block == repeaterIdle || block == repeaterActv)) {
            int tick = (accessor.getMetadata() >> 2) + 1;
            if (tick == 1) {
                currenttip.add(String.format("%s : %s tick", LangUtil.translateG("hud.msg.delay", new Object[0]), tick));
            } else {
                currenttip.add(String.format("%s : %s ticks", LangUtil.translateG("hud.msg.delay", new Object[0]), tick));
            }
            return currenttip;
        }
        if (config.getConfig("vanilla.comparator") && (block == comparatorIdl || block == comparatorAct)) {
            String mode = (accessor.getMetadata() >> 2 & 1) == 0 ? LangUtil.translateG("hud.msg.comparator", new Object[0]) : LangUtil.translateG("hud.msg.substractor", new Object[0]);
            currenttip.add("Mode : " + mode);
            return currenttip;
        }
        if (config.getConfig("vanilla.redstone") && block == redstone) {
            currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.power", new Object[0]), accessor.getMetadata()));
            return currenttip;
        }
        if (config.getConfig("vanilla.jukebox") && block == jukebox) {
            NBTTagCompound tag = accessor.getNBTData();
            if (tag.func_150297_b("RecordItem", 10)) {
                Item record = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("RecordItem")).func_77973_b();
                currenttip.add(LangUtil.translateG("record.nowPlaying", ((ItemRecord)record).func_150927_i()));
            } else {
                currenttip.add(LangUtil.translateG("hud.msg.empty", new Object[0]));
            }
        }
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return te.func_189515_b(tag);
    }

    public static void register(IWailaRegistrar registrar) {
        registrar.addConfig("VanillaMC", "vanilla.spawntype");
        registrar.addConfig("VanillaMC", "vanilla.leverstate");
        registrar.addConfig("VanillaMC", "vanilla.repeater");
        registrar.addConfig("VanillaMC", "vanilla.comparator");
        registrar.addConfig("VanillaMC", "vanilla.redstone");
        registrar.addConfig("VanillaMC", "vanilla.silverfish");
        registrar.addConfig("VanillaMC", "vanilla.alternatecropitem");
        registrar.addConfigRemote("VanillaMC", "vanilla.jukebox");
        HUDHandlerVanilla provider = new HUDHandlerVanilla();
        registrar.registerStackProvider(provider, silverfish.getClass());
        registrar.registerStackProvider(provider, flowerpot.getClass());
        registrar.registerStackProvider(provider, crops.getClass());
        registrar.registerStackProvider(provider, beet.getClass());
        registrar.registerStackProvider(provider, farmland.getClass());
        registrar.registerHeadProvider(provider, mobSpawner.getClass());
        registrar.registerHeadProvider(provider, melonStem.getClass());
        registrar.registerHeadProvider(provider, pumpkinStem.getClass());
        registrar.registerHeadProvider(provider, redstone.getClass());
        registrar.registerBodyProvider(provider, BlockCrops.class);
        registrar.registerBodyProvider(provider, melonStem.getClass());
        registrar.registerBodyProvider(provider, pumpkinStem.getClass());
        registrar.registerBodyProvider(provider, cocoa.getClass());
        registrar.registerBodyProvider(provider, netherwart.getClass());
        registrar.registerBodyProvider(provider, lever.getClass());
        registrar.registerBodyProvider(provider, repeaterIdle.getClass());
        registrar.registerBodyProvider(provider, repeaterActv.getClass());
        registrar.registerBodyProvider(provider, comparatorIdl.getClass());
        registrar.registerBodyProvider(provider, comparatorAct.getClass());
        registrar.registerBodyProvider(provider, redstone.getClass());
        registrar.registerBodyProvider(provider, jukebox.getClass());
        registrar.registerNBTProvider(provider, jukebox.getClass());
    }

    static {
        mobSpawner = Blocks.field_150474_ac;
        crops = Blocks.field_150464_aj;
        beet = Blocks.field_185773_cZ;
        farmland = Blocks.field_150458_ak;
        melonStem = Blocks.field_150394_bc;
        pumpkinStem = Blocks.field_150393_bb;
        lever = Blocks.field_150442_at;
        repeaterIdle = Blocks.field_150413_aR;
        repeaterActv = Blocks.field_150416_aS;
        comparatorIdl = Blocks.field_150441_bU;
        comparatorAct = Blocks.field_150455_bV;
        redstone = Blocks.field_150488_af;
        jukebox = Blocks.field_150421_aI;
        cocoa = Blocks.field_150375_by;
        netherwart = Blocks.field_150388_bm;
        silverfish = Blocks.field_150418_aU;
        flowerpot = Blocks.field_150457_bL;
    }
}

