/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.compatibility;

import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.dimensions.workhousedim.WorldProviderSpecialDim;
import com.rwtema.extrautils2.utils.datastructures.FieldSetter;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SpecialDimCompat {
    public static final FieldSetter<World, WorldProvider> providerFieldSetter = new FieldSetter(World.class, "field_73011_w", "provider");
    public static final FieldSetter<ChunkProviderEnd, World> endWorldFieldSetter = new FieldSetter(ChunkProviderEnd.class, "field_73230_p", "world", "worldObj");
    public static final FieldSetter<ChunkProviderHell, World> hellWorldFieldSetter = new FieldSetter(ChunkProviderHell.class, "field_185952_n", "world", "worldObj");
    public static ChunkProviderEnd tempEnd = null;
    public static ChunkProviderHell tempHell = null;
    public static WorldProviderHell providerHell = (WorldProviderHell)DimensionManager.createProviderFor((int)-1);
    public static WorldProviderEnd providerEnd = (WorldProviderEnd)DimensionManager.createProviderFor((int)1);

    @Nonnull
    public static Object getEndGenerator(Biome targetBiome, WorldServer world) {
        ChunkProviderEnd generator = tempEnd;
        if (generator == null) {
            tempEnd = generator = CompatHelper.getChunkProviderEnd(world);
        } else {
            endWorldFieldSetter.apply(generator, (World)world);
        }
        providerEnd.func_76558_a((World)world);
        providerEnd.setDimension(1);
        providerFieldSetter.apply((World)world, (WorldProvider)providerEnd);
        return generator;
    }

    public static void clearEndData(WorldServer world, WorldProvider provider) {
        WorldProviderSpecialDim.isEnd = false;
        endWorldFieldSetter.apply(tempEnd, null);
        providerFieldSetter.apply((World)world, provider);
    }

    @Nonnull
    public static IChunkGenerator getNetherGen(Biome targetBiome, WorldServer world) {
        ChunkProviderHell generator = tempHell;
        if (generator == null) {
            int seaLevel = world.func_181545_F();
            generator = new ChunkProviderHell((World)world, true, world.func_72905_C()){

                @Nonnull
                public Chunk func_185932_a(int x, int z) {
                    Chunk chunk = super.func_185932_a(x, z);
                    for (ExtendedBlockStorage extendedBlockStorage : chunk.func_76587_i()) {
                        if (extendedBlockStorage == null || extendedBlockStorage.func_76661_k() != null) continue;
                        extendedBlockStorage.func_76659_c(new NibbleArray());
                    }
                    return chunk;
                }
            };
            world.func_181544_b(seaLevel);
            tempHell = generator;
        } else {
            hellWorldFieldSetter.apply(generator, (World)world);
        }
        providerHell.func_76558_a((World)world);
        providerHell.setDimension(-1);
        providerFieldSetter.apply((World)world, (WorldProvider)providerHell);
        return generator;
    }

    public static void clearNetherData(WorldServer world, WorldProvider provider) {
        WorldProviderSpecialDim.isNether = false;
        hellWorldFieldSetter.apply(tempHell, null);
        providerFieldSetter.apply((World)world, provider);
    }

    public static void populate(Chunk chunk, Object generator) {
        ((IChunkGenerator)generator).func_185931_b(chunk.field_76635_g, chunk.field_76647_h);
        GameRegistry.generateWorld((int)chunk.field_76635_g, (int)chunk.field_76647_h, (World)chunk.func_177412_p(), (IChunkGenerator)((IChunkGenerator)generator), (IChunkProvider)chunk.func_177412_p().func_72863_F());
    }
}

