/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.compatibility;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.api.recipes.ICustomRecipeMatching;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.compatibility.CraftingHelper112;
import com.rwtema.extrautils2.compatibility.ShapedOreCompat;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.IItemMatcher;
import com.rwtema.extrautils2.utils.datastructures.ConcatList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class XUShapedRecipe
extends ShapedOreCompat
implements IItemMatcher {
    public BiFunction<ItemStack, InventoryCrafting, ItemStack> finalOutputTransform = null;

    public XUShapedRecipe(ResourceLocation location, Block result, Object ... recipe) {
        this(location, new ItemStack(result), recipe);
    }

    public XUShapedRecipe(ResourceLocation location, Item result, Object ... recipe) {
        this(location, new ItemStack(result), recipe);
    }

    public XUShapedRecipe(ResourceLocation location, ItemStack result, Object ... recipe) {
        super(result, CraftingHelper112.getShapedIngredientRecipes(recipe));
        this.output = result.func_77946_l();
        CraftingHelper112.processRecipe(this, result, recipe);
    }

    public static void handleListInput(List<ItemStack> list, Object in) {
        if (in instanceof ItemStack) {
            list.add(((ItemStack)in).func_77946_l());
        } else if (in instanceof Item) {
            list.add(new ItemStack((Item)in));
        } else if (in instanceof Block) {
            list.add(new ItemStack((Block)in, 1, Short.MAX_VALUE));
        } else if (in instanceof String) {
            list.addAll(OreDictionary.getOres((String)((String)in)));
        } else if (in instanceof IItemStackMaker) {
            list.add(((IItemStackMaker)in).newStack());
        } else if (in instanceof IBlockState) {
            IBlockState state = (IBlockState)in;
            Block block = state.func_177230_c();
            Item itemDropped = block.func_180660_a(state, null, 0);
            if (itemDropped != StackHelper.nullItem()) {
                list.add(new ItemStack(itemDropped, 1, block.func_180651_a(state)));
            }
        } else if (in instanceof Collection) {
            if (in instanceof List) {
                boolean allStacks = true;
                for (Object o : (List)in) {
                    if (o instanceof ItemStack) continue;
                    allStacks = false;
                    break;
                }
                if (allStacks) {
                    list.addAll((List)in);
                    return;
                }
            }
            for (Object o : (Collection)in) {
                XUShapedRecipe.handleListInput(list, o);
            }
        } else {
            String ret = "Invalid shaped ore input: ";
            ret = ret + in;
            throw new RuntimeException(ret);
        }
    }

    public static List<ItemStack> getRecipeStackList(Object in) {
        ItemStack itemStack;
        ConcatList<ItemStack> list = new ConcatList<ItemStack>();
        XUShapedRecipe.handleListInput(list, in);
        Object out = list.subLists.size() == 1 ? (list.size() == 1 ? (StackHelper.isNonNull(itemStack = (ItemStack)list.modifiableList.get(0)) ? ImmutableList.of((Object)itemStack) : ImmutableList.of()) : list.modifiableList) : (list.subLists.size() == 2 && list.modifiableList.isEmpty() ? list.subLists.get(1) : list);
        return out;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (this.itemsMatch(slot, (ItemStack)target)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = this.itemsMatch(slot, (ItemStack)itr.next());
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || !StackHelper.isNonNull(slot)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean itemsMatch(ItemStack slot, @Nonnull ItemStack target) {
        Block block;
        Item item = target.func_77973_b();
        if (item instanceof ICustomRecipeMatching) {
            return ((ICustomRecipeMatching)item).itemsMatch(slot, target);
        }
        if (item instanceof ItemBlock && (block = ((ItemBlock)item).field_150939_a) instanceof ICustomRecipeMatching) {
            return ((ICustomRecipeMatching)block).itemsMatch(slot, target);
        }
        return OreDictionary.itemMatches((ItemStack)target, (ItemStack)slot, (boolean)false);
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        ItemStack result = super.func_77572_b(var1);
        if (this.finalOutputTransform != null) {
            return this.finalOutputTransform.apply(result, var1);
        }
        return result;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void setInput(Object[] input) {
        this.input = input;
    }
}

