/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.rwtema.extrautils2.api.machine.XUMachineGenerators;
import com.rwtema.extrautils2.machine.EnergyBaseRecipe;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

class FoodEnergyRecipe
extends EnergyBaseRecipe {
    public FoodEnergyRecipe() {
        super(XUMachineGenerators.INPUT_ITEM);
    }

    public static int nerfLevels(double energy, double maxLevel) {
        if (energy < maxLevel) {
            return (int)Math.ceil(energy);
        }
        double f = 1.0;
        double totalEnergy = 0.0;
        while (energy > maxLevel) {
            totalEnergy += maxLevel / f;
            energy -= maxLevel;
            f += 1.0;
        }
        return (int)Math.ceil(totalEnergy += energy / f);
    }

    @Override
    public int getEnergyOutput(@Nonnull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (!(item instanceof ItemFood)) {
            return 0;
        }
        ItemFood food = (ItemFood)item;
        if (!this.isValid(food)) {
            return 0;
        }
        int healAmount = this.getHealAmount(itemStack, food);
        return FoodEnergyRecipe.nerfLevels((float)healAmount * this.getSaturationModifier(itemStack, food) * 8000.0f, 64000.0);
    }

    private float getSaturationModifier(@Nonnull ItemStack itemStack, ItemFood food) {
        Potion potion;
        float saturationModifier = food.func_150906_h(itemStack);
        PotionEffect potionId = food.field_77851_ca;
        if (potionId != null && (potion = potionId.func_188419_a()) == MobEffects.field_76443_y) {
            saturationModifier = Math.max(1.0f, saturationModifier);
        }
        return saturationModifier;
    }

    private int getHealAmount(@Nonnull ItemStack itemStack, ItemFood food) {
        float healAmount = food.func_150905_g(itemStack);
        PotionEffect potionId = food.field_77851_ca;
        if (potionId != null) {
            Potion potion = potionId.func_188419_a();
            healAmount = potion == MobEffects.field_76432_h ? (healAmount += (float)Math.min(4 << potionId.func_76458_c(), 20)) : (potion == MobEffects.field_76443_y ? (healAmount += (float)(potionId.func_76458_c() + 1) / 2.0f) : (potion == MobEffects.field_76428_l ? (healAmount += (float)(potionId.func_76459_b() / (50 >> potionId.func_76458_c())) / 4.0f) : (potion == MobEffects.field_76444_x ? (healAmount += (float)(potionId.func_76458_c() + 1) / 2.0f) : (healAmount += 1.0f))));
        }
        if (food == Items.field_151153_ao) {
            healAmount = itemStack.func_77960_j() > 0 ? (healAmount += 12.0f) : (healAmount += 3.0f);
        }
        return (int)(healAmount + 0.5f);
    }

    @Override
    protected float getEnergyRate(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemFood)) {
            return 0.0f;
        }
        ItemFood food = (ItemFood)item;
        int healAmount = this.getHealAmount(stack, food);
        return Math.max(FoodEnergyRecipe.nerfLevels(healAmount * 8, 64.0), 1);
    }

    public boolean isValid(ItemFood food) {
        return food.field_77851_ca == null || !food.field_77851_ca.func_188419_a().func_76398_f();
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getInputValues() {
        return EnergyBaseRecipe.getCreativeStacks(null, item -> item instanceof ItemFood && this.isValid((ItemFood)item));
    }
}

