/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.biome.overworld.BOPBiome;
import biomesoplenty.common.block.BlockBOPGeneric;
import biomesoplenty.common.util.biome.BiomeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BlockBOPBiomeBlock
extends BlockBOPGeneric {
    private static List<Biome> biomesWithEssence;

    public BlockBOPBiomeBlock() {
        super(Material.field_151592_s, SoundType.field_185853_f);
        this.func_149711_c(0.6f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public List<Biome> getBiomesWithEssence() {
        if (biomesWithEssence != null) {
            return biomesWithEssence;
        }
        biomesWithEssence = new ArrayList<Biome>();
        List<Biome> vanillaBiomesToExclude = Arrays.asList(Biomes.field_76779_k, Biomes.field_76778_j, Biomes.field_76787_r, Biomes.field_150577_O, Biomes.field_150576_N, Biomes.field_76771_b, Biomes.field_76776_l, Biomes.field_150575_M, Biomes.field_76781_i, Biomes.field_76777_m);
        for (Biome biome : BiomeUtils.getRegisteredBiomes()) {
            if (biome == null) continue;
            if (biome instanceof BOPBiome) {
                if (!((BOPBiome)biome).hasBiomeEssence()) continue;
                biomesWithEssence.add(biome);
                continue;
            }
            if (vanillaBiomesToExclude.contains(biome)) continue;
            biomesWithEssence.add(biome);
        }
        return biomesWithEssence;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        List<Biome> biomes = this.getBiomesWithEssence();
        int numToDrop = rand.nextInt(fortune + 2) + 1;
        int numChoices = biomes.size();
        for (int i = 0; i < numToDrop; ++i) {
            Biome biome = biomes.get(rand.nextInt(numChoices));
            ItemStack biome_essence = new ItemStack(BOPItems.biome_essence);
            biome_essence.func_77982_d(new NBTTagCompound());
            biome_essence.func_77978_p().func_74768_a("biomeID", Biome.func_185362_a((Biome)biome));
            ret.add(biome_essence);
        }
        return ret;
    }
}

